/* COPYRIGHT_BEGIN
 *    Copyright (c) 1991 SGI   All Rights Reserved
 *    THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF SGI
 *    The copyright notice above does not evidence any
 *    actual or intended publication of such source code,
 *    and is an unpublished work by Silicon Graphics, Inc.
 *    This material contains CONFIDENTIAL INFORMATION that
 *    is the property of Silicon Graphics, Inc. Any use,
 *    duplication or disclosure not specifically authorized
 *    by Silicon Graphics is strictly prohibited.
 *    
 *    RESTRICTED RIGHTS LEGEND:
 *    
 *    Use, duplication or disclosure by the Government is
 *    subject to restrictions as set forth in subdivision
 *    (c)(1)(ii) of the Rights in Technical Data and Computer
 *    Software clause at DFARS 52.227-7013, and/or in similar
 *    or successor clauses in the FAR, DOD or NASA FAR
 *    Supplement.  Unpublished- rights reserved under the
 *    Copyright Laws of the United States.  Contractor is
 *    SILICON GRAPHICS, INC., 2011 N. Shoreline Blvd.,
 *    Mountain View, CA 94039-7311
 * COPYRIGHT_END */

/* 
 * Module data wrapper subprogram for module WorldMap.
 * Automatically created by module builder at Wed Jan 13 15:58:04 1993.
 * 
 */


/* System include files. */
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#ifdef _CRAY
#include <fortran.h>
#endif

/* include files from $EXPLORERHOME/include  */
#include <cx/Typedefs.h>
#include <cx/ModuleCommand.h>
#include <cx/DataOps.h>
#include <cx/PortAccess.h>
#include <cx/Coerce.h>
#include <cx/cxMetaType.h>
#include <cx/TypeMismatchMsg.h>
#include <cx/UserFuncs.h>

#include <cx/UDT.h>

#include <cx/Info.h>

#include <cx/DataAccess.h>
#include <cx/cxParameter.api.h>
#include <cx/cxPyramid.api.h>

/* No user specified include files. */



  /* --- User Fcn call prototype. --- */
#include <cx/cxParameter.api.h>
#include <cx/cxPyramid.api.h>

#ifdef __cplusplus
	extern "C" {
#endif

  void 	makemap  (
	 unsigned char   	 *mapDir, 
	 long   	  bdyLevel, 
	 long   	  cilLevel, 
	 long   	  reefLevel, 
	 long   	  parLevel, 
	 long   	  iceLevel, 
	 long   	  meridLevel, 
	 long   	  riverLevel, 
	 long   	  canalLevel, 
	 cxPyramid *	* pyrout, 
	 long   	  precision, 
	 cxParameter *	  xmin, 
	 cxParameter *	  xmax, 
	 cxParameter *	  ymin, 
	 cxParameter *	  ymax, 
	 long   	  pbyLevel, 
	 long   	  plateLevel );

#ifdef __cplusplus
}
#endif


/* Number of user function arguments. */
#define cxMDWNARGmakemap 17

long cxMDWmakemap( )
{

/* ----- Beginning of port declarations ----- */

/* Port dataset variable declarations */

  cxParameter *cxP_In_CIA_Map_Directory;
  cxParameter *cxP_In_Precision;
  cxParameter *cxP_In_International;
  cxParameter *cxP_In_National;
  cxParameter *cxP_In_Coasts__Islands__and_Lakes;
  cxParameter *cxP_In_Rivers;
  cxParameter *cxP_In_Reefs__etc_;
  cxParameter *cxP_In_Ice;
  cxParameter *cxP_In_Canals;
  cxParameter *cxP_In_Plates;
  cxParameter *cxP_In_Parallels;
  cxParameter *cxP_In_Meridians;
  cxParameter *cxP_In_Min_Longitude;
  cxParameter *cxP_In_Max_Longitude;
  cxParameter *cxP_In_Min_Latitude;
  cxParameter *cxP_In_Max_Latitude;
  cxPyramid *cxP_Out_Output;

/* --- End of port and dataset declarations ---- */


/* -- Beginning of User Fcn variable declarations -- */

  unsigned char   *mapDir; 
  long    bdyLevel; 
  long    cilLevel; 
  long    reefLevel; 
  long    parLevel; 
  long    iceLevel; 
  long    meridLevel; 
  long    riverLevel; 
  long    canalLevel; 
  cxPyramid * pyrout; 
  long    precision; 
  cxParameter * xmin; 
  cxParameter * xmax; 
  cxParameter * ymin; 
  cxParameter * ymax; 
  long    pbyLevel; 
  long    plateLevel; 

/* ------ End of User Fcn declarations ------ */

  long   cxMDWi, cxMDWIrc;
  long   cxMDWIfCoerce[ cxMDWNARGmakemap ];
  char *cxMDWStr;
  long  cxMDWFuncRetCode;
  char  cxMDWFuncBuf[256];
  long  cxMDWLen;
  long  cxMDWPortIDIn[16];
  long  cxMDWPortIDOut[1];
  void *tmp;
  int  *cxMDWTypeTab;
  cxDataCheckErrorInfo  *cxMDWCheckErr;
  cxErrorCode   ec;
/* ------------------------------------------ */
/* ----- Beginning of Port Associations ----- */

/* -------- First executable statment ------- */


  /* Get input port handles. */ 
  cxMDWPortIDIn[0] = cxInputPortOpen( "CIA Map Directory" );
  cxMDWPortIDIn[1] = cxInputPortOpen( "Precision" );
  cxMDWPortIDIn[2] = cxInputPortOpen( "International" );
  cxMDWPortIDIn[3] = cxInputPortOpen( "National" );
  cxMDWPortIDIn[4] = cxInputPortOpen( "Coasts, Islands, and Lakes" );
  cxMDWPortIDIn[5] = cxInputPortOpen( "Rivers" );
  cxMDWPortIDIn[6] = cxInputPortOpen( "Reefs, etc." );
  cxMDWPortIDIn[7] = cxInputPortOpen( "Ice" );
  cxMDWPortIDIn[8] = cxInputPortOpen( "Canals" );
  cxMDWPortIDIn[9] = cxInputPortOpen( "Plates" );
  cxMDWPortIDIn[10] = cxInputPortOpen( "Parallels" );
  cxMDWPortIDIn[11] = cxInputPortOpen( "Meridians" );
  cxMDWPortIDIn[12] = cxInputPortOpen( "Min Longitude" );
  cxMDWPortIDIn[13] = cxInputPortOpen( "Max Longitude" );
  cxMDWPortIDIn[14] = cxInputPortOpen( "Min Latitude" );
  cxMDWPortIDIn[15] = cxInputPortOpen( "Max Latitude" );

  /* Get output port handles. */ 
  cxMDWPortIDOut[0] = cxOutputPortOpen( "Output" );

  /* Get dataset pointers. */ 
  cxP_In_CIA_Map_Directory = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[0] );
  cxP_In_Precision = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[1] );
  cxP_In_International = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[2] );
  cxP_In_National = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[3] );
  cxP_In_Coasts__Islands__and_Lakes = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[4] );
  cxP_In_Rivers = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[5] );
  cxP_In_Reefs__etc_ = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[6] );
  cxP_In_Ice = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[7] );
  cxP_In_Canals = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[8] );
  cxP_In_Plates = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[9] );
  cxP_In_Parallels = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[10] );
  cxP_In_Meridians = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[11] );
  cxP_In_Min_Longitude = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[12] );
  cxP_In_Max_Longitude = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[13] );
  cxP_In_Min_Latitude = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[14] );
  cxP_In_Max_Latitude = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[15] );

  /* Initialize the coercion status flags. */
  for (cxMDWi=0; cxMDWi< cxMDWNARGmakemap; cxMDWi++) 
    cxMDWIfCoerce[cxMDWi] = TRUE;


  /* Assign user function values. */
  /* Extracting User Function variables from ports. */

  if (0 && !cxP_In_CIA_Map_Directory) {
    mapDir = NULL;
    cxMDWIfCoerce[0] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_string );	/* return of type (char * *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_CIA_Map_Directory, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_CIA_Map_Directory, &ec ) ), 
	  cx_prim_string, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    mapDir = *(char * *) tmp;

    cxMDWIfCoerce[0] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_International) {
    bdyLevel = NULL;
    cxMDWIfCoerce[1] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_long );	/* return of type (long    *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_International, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_International, &ec ) ), 
	  cx_prim_long, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    bdyLevel = *(long    *) tmp;

    cxMDWIfCoerce[1] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Coasts__Islands__and_Lakes) {
    cilLevel = NULL;
    cxMDWIfCoerce[2] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_long );	/* return of type (long    *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Coasts__Islands__and_Lakes, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Coasts__Islands__and_Lakes, &ec ) ), 
	  cx_prim_long, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    cilLevel = *(long    *) tmp;

    cxMDWIfCoerce[2] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Reefs__etc_) {
    reefLevel = NULL;
    cxMDWIfCoerce[3] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_long );	/* return of type (long    *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Reefs__etc_, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Reefs__etc_, &ec ) ), 
	  cx_prim_long, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    reefLevel = *(long    *) tmp;

    cxMDWIfCoerce[3] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Parallels) {
    parLevel = NULL;
    cxMDWIfCoerce[4] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_long );	/* return of type (long    *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Parallels, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Parallels, &ec ) ), 
	  cx_prim_long, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    parLevel = *(long    *) tmp;

    cxMDWIfCoerce[4] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Ice) {
    iceLevel = NULL;
    cxMDWIfCoerce[5] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_long );	/* return of type (long    *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Ice, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Ice, &ec ) ), 
	  cx_prim_long, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    iceLevel = *(long    *) tmp;

    cxMDWIfCoerce[5] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Meridians) {
    meridLevel = NULL;
    cxMDWIfCoerce[6] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_long );	/* return of type (long    *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Meridians, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Meridians, &ec ) ), 
	  cx_prim_long, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    meridLevel = *(long    *) tmp;

    cxMDWIfCoerce[6] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Rivers) {
    riverLevel = NULL;
    cxMDWIfCoerce[7] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_long );	/* return of type (long    *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Rivers, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Rivers, &ec ) ), 
	  cx_prim_long, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    riverLevel = *(long    *) tmp;

    cxMDWIfCoerce[7] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Canals) {
    canalLevel = NULL;
    cxMDWIfCoerce[8] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_long );	/* return of type (long    *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Canals, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Canals, &ec ) ), 
	  cx_prim_long, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    canalLevel = *(long    *) tmp;

    cxMDWIfCoerce[8] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Precision) {
    precision = NULL;
    cxMDWIfCoerce[10] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_long );	/* return of type (long    *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Precision, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Precision, &ec ) ), 
	  cx_prim_long, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    precision = *(long    *) tmp;

    cxMDWIfCoerce[10] = FALSE;
    cxVecDel( tmp );
  }

  if (1 && !cxP_In_Min_Longitude) {
    xmin = NULL;
    cxMDWIfCoerce[11] = FALSE;
  }
  else {
  xmin = (cxParameter *) cxP_In_Min_Longitude;
  }

  if (1 && !cxP_In_Max_Longitude) {
    xmax = NULL;
    cxMDWIfCoerce[12] = FALSE;
  }
  else {
  xmax = (cxParameter *) cxP_In_Max_Longitude;
  }

  if (1 && !cxP_In_Min_Latitude) {
    ymin = NULL;
    cxMDWIfCoerce[13] = FALSE;
  }
  else {
  ymin = (cxParameter *) cxP_In_Min_Latitude;
  }

  if (1 && !cxP_In_Max_Latitude) {
    ymax = NULL;
    cxMDWIfCoerce[14] = FALSE;
  }
  else {
  ymax = (cxParameter *) cxP_In_Max_Latitude;
  }

  if (0 && !cxP_In_National) {
    pbyLevel = NULL;
    cxMDWIfCoerce[15] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_long );	/* return of type (long    *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_National, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_National, &ec ) ), 
	  cx_prim_long, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    pbyLevel = *(long    *) tmp;

    cxMDWIfCoerce[15] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Plates) {
    plateLevel = NULL;
    cxMDWIfCoerce[16] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_long );	/* return of type (long    *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Plates, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Plates, &ec ) ), 
	  cx_prim_long, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    plateLevel = *(long    *) tmp;

    cxMDWIfCoerce[16] = FALSE;
    cxVecDel( tmp );
  }
  /* Assigning constant User Function variables. */
  /* Assigning whether data has changed to User Function variables. */
  /* Allocation of User Function variables. */
  pyrout = (cxPyramid *) NULL; 

  makemap( mapDir, 
      bdyLevel, cilLevel, reefLevel, parLevel, 
      iceLevel, meridLevel, riverLevel, canalLevel, 
      &pyrout, precision, xmin, xmax, 
      ymin, ymax, pbyLevel, plateLevel );

  if (cxDataAllocErrorGet())
    return( cx_err_error );

 if ( (cxMDWCheckErr = cxMemBoundsCheck( (void*) mapDir, 0 )) != NULL) {
  cxDataCheckErrorInfoDel( cxMDWCheckErr );
  cxModAlert( cxMDWCheckErr->msg );
  return( cx_err_error );
}
/* Beginning of output port assembly. */

  /* Output port assembly for port "Output". */

  cxP_Out_Output = (cxPyramid *) pyrout;








/* End of output port assembly. */


/* Free temporarily assigned user vars. */

  cxOutputDataSet( cxMDWPortIDOut[0], (void *)cxP_Out_Output );
  return( cx_err_none );
}
