/* ------------------------------------------- */
/*
 *   Author: James Phillips
 *           Department of Physics
 *           Marquette University
 *           Milwaukee, WI 53233
 *
 *   Purpose: Explorer module which creates a 
 *            sphere at the origin.
 *
 *   Written for the David A. Yuen research group
 *   at the Minnesota Supercomputer Institute and
 *   Department of Geology and Geophysics, 
 *   University of Minnesota.  Summer, 1992.
 *
 */
/* ------------------------------------------- */
#include <cx/DataTypes.h>
#include <cx/Geometry.h>

#ifdef __cplusplus
	extern "C" {
#endif

  void 	sphere  (
	 double 	  radius,
	 cxGeometry   *	* geom,
         long             color,
         double           value)
{

   cxGeometry *geomOut;
   float point[3];
   float rad[1];
   float colors[3];
   float comp;

   *geom = NULL;

   if ( radius <= 0.0 ) return;

   point[0] = 0.0;
   point[1] = 0.0;
   point[2] = 0.0;
   rad[0] = radius;
   comp = 1.0;
   colors[0] = value;
   colors[1] = value;
   colors[2] = value;

   cxGeoInit();
   geomOut = cxGeoNew();
   cxGeoBufferSelect(geomOut);
   cxGeoRoot();
   cxGeoDelete();

   cxGeoSpheresDefine(1,point,rad);
   cxGeoComplexityAdd(comp);
   if ( ! color ) cxGeoColorAdd(1,colors,CX_GEO_PER_OBJECT);

   cxGeoBufferClose(geomOut);

   *geom = geomOut;

   return;

}

#ifdef __cplusplus
}
#endif
/* ------------------------------------------- */

