/* COPYRIGHT_BEGIN
 *    Copyright (c) 1991 SGI   All Rights Reserved
 *    THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF SGI
 *    The copyright notice above does not evidence any
 *    actual or intended publication of such source code,
 *    and is an unpublished work by Silicon Graphics, Inc.
 *    This material contains CONFIDENTIAL INFORMATION that
 *    is the property of Silicon Graphics, Inc. Any use,
 *    duplication or disclosure not specifically authorized
 *    by Silicon Graphics is strictly prohibited.
 *    
 *    RESTRICTED RIGHTS LEGEND:
 *    
 *    Use, duplication or disclosure by the Government is
 *    subject to restrictions as set forth in subdivision
 *    (c)(1)(ii) of the Rights in Technical Data and Computer
 *    Software clause at DFARS 52.227-7013, and/or in similar
 *    or successor clauses in the FAR, DOD or NASA FAR
 *    Supplement.  Unpublished- rights reserved under the
 *    Copyright Laws of the United States.  Contractor is
 *    SILICON GRAPHICS, INC., 2011 N. Shoreline Blvd.,
 *    Mountain View, CA 94039-7311
 * COPYRIGHT_END */

/* 
 * Module generic routines subprogram for module CoordCrop.
 * Automatically created by module builder at Wed Jan 13 11:40:29 1993.
 * 
 */


/* System include files. */
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#ifdef _CRAY
#include <fortran.h>
#endif

/* include files from $EXPLORERHOME/include  */
#include <cx/Typedefs.h>
#include <cx/ModuleCommand.h>
#include <cx/DataOps.h>
#include <cx/PortAccess.h>
#include <cx/Coerce.h>
#include <cx/cxMetaType.h>
#include <cx/TypeMismatchMsg.h>
#include <cx/UserFuncs.h>

#include <cx/UDT.h>

#include <cx/Info.h>

#include <cx/DataAccess.h>
#include <cx/cxParameter.api.h>
#include <cx/cxLattice.api.h>

/* No user specified include files. */


#ifdef __cplusplus
	extern "C" {
#endif
/*****************************************************/

/* Entry points for MCW calling. */
extern long cxMDWcoordcrop(void);

cxFuncTable cx_FuncTable[] = {
		 (cxFuncTable)cxMDWcoordcrop,
		 NULL
};


extern cxMetaType cx_cxMetaTypeMetaType;
extern cxMetaType cx_cxParameterMetaType;
extern cxMetaType cx_cxLatticeMetaType;

void cxModuleMetaTypeInit(void) 
{
    cxMetaTypeAdd(&cx_cxMetaTypeMetaType);
    cxMetaTypeAdd(&cx_cxParameterMetaType);
    cxMetaTypeAdd(&cx_cxLatticeMetaType);

}

/*****************************************************/

/* Entry points for Hook Function calling. */

cxHookTable cx_HookTable[] = {
    { cx_func_last}
};
/*****************************************************/
/* Check Input ports against constraints in module resources. */
cxErrorCode cxPortCheckIn ( int portC, void *ports[], long *cxMDWPortID ) 
{
  cxErrorCode   ec;
  int           portOK;
  void         *cxChkDat;
  char          buf[128], *portData, *msg;


  /* Can't do port checking on alternate executables. */

  if (strcmp( "CoordCrop", cxModuleNameGet()) != NULL)
    return cx_err_none;
  /* Can't do port checking on variable # ports. */

  if (portC != 9)
    return cx_err_none;
  /* Checking contents of Input datasets. */

  /* No typing information for port 0. */

  /* No typing information for port 1. */

  /* No typing information for port 2. */

  /* No typing information for port 3. */

  /* No typing information for port 4. */

  /* No typing information for port 5. */
  cxChkDat  = ports[6];
  if (cxChkDat) {
    /* Only check optional port when it has data */
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxData *) 1) <= ((cxLattice *) cxChkDat)->data);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Data Structure", 
		    "->data", 
		    portData, 
		    "((cxData *) 1)", 
		    "" );
      cxInputDataRelease( cxMDWPortID[6] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxCoord *) 1) <= ((cxLattice *) cxChkDat)->coord);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->coord );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Coord Structure", 
		    "->coord", 
		    portData, 
		    "((cxCoord *) 1)", 
		    "" );
      cxInputDataRelease( cxMDWPortID[6] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (2 <= ((cxLattice *) cxChkDat)->nDim 
                         && ((cxLattice *) cxChkDat)->nDim<= 3);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->nDim );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Num Dimensions", 
		    "->nDim", 
		    portData, 
		    "2", 
		    "3" );
      cxInputDataRelease( cxMDWPortID[6] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->data || 
	(1 <= ((cxLattice *) cxChkDat)->data->nDataVar);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data->nDataVar );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Num Data Variables", 
		    "->data->nDataVar", 
		    portData, 
		    "1", 
		    "" );
      cxInputDataRelease( cxMDWPortID[6] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->data || 
	(cx_prim_byte <= ((cxLattice *) cxChkDat)->data->primType 
                         && ((cxLattice *) cxChkDat)->data->primType<= cx_prim_double);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxLattice *) cxChkDat)->data->primType, 
				"cxPrimType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data->primType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Primitive Data Type", 
		    "->data->primType", 
		    portData, 
		    "cx_prim_byte", 
		    "cx_prim_double" );
      cxInputDataRelease( cxMDWPortID[6] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->coord || 
	(cx_coord_uniform <= ((cxLattice *) cxChkDat)->coord->coordType 
                         && ((cxLattice *) cxChkDat)->coord->coordType<= cx_coord_perimeter);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxLattice *) cxChkDat)->coord->coordType, 
				"cxCoordType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->coord->coordType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Coord Type", 
		    "->coord->coordType", 
		    portData, 
		    "cx_coord_uniform", 
		    "cx_coord_perimeter" );
      cxInputDataRelease( cxMDWPortID[6] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->coord || 
	(2 <= *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) ) 
                         && *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) )<= 3);
    if (!portOK) {
      sprintf( buf, "%d", *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) ) );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Num Coord Dimensions", 
		    "->coord->c.cx_coord_curvilinear.nCoordVar", 
		    portData, 
		    "2", 
		    "3" );
      cxInputDataRelease( cxMDWPortID[6] );
      cxModAlert( msg );
      return cx_err_error;
      }
  }
  cxChkDat  = ports[7];
  if (cxChkDat) {
    /* Only check optional port when it has data */
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxData *) 1) <= ((cxLattice *) cxChkDat)->data);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Data Structure", 
		    "->data", 
		    portData, 
		    "((cxData *) 1)", 
		    "" );
      cxInputDataRelease( cxMDWPortID[7] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxCoord *) 1) <= ((cxLattice *) cxChkDat)->coord);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->coord );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Coord Structure", 
		    "->coord", 
		    portData, 
		    "((cxCoord *) 1)", 
		    "" );
      cxInputDataRelease( cxMDWPortID[7] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (2 <= ((cxLattice *) cxChkDat)->nDim 
                         && ((cxLattice *) cxChkDat)->nDim<= 3);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->nDim );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Num Dimensions", 
		    "->nDim", 
		    portData, 
		    "2", 
		    "3" );
      cxInputDataRelease( cxMDWPortID[7] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->data || 
	(1 <= ((cxLattice *) cxChkDat)->data->nDataVar);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data->nDataVar );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Num Data Variables", 
		    "->data->nDataVar", 
		    portData, 
		    "1", 
		    "" );
      cxInputDataRelease( cxMDWPortID[7] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->data || 
	(cx_prim_byte <= ((cxLattice *) cxChkDat)->data->primType 
                         && ((cxLattice *) cxChkDat)->data->primType<= cx_prim_double);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxLattice *) cxChkDat)->data->primType, 
				"cxPrimType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data->primType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Primitive Data Type", 
		    "->data->primType", 
		    portData, 
		    "cx_prim_byte", 
		    "cx_prim_double" );
      cxInputDataRelease( cxMDWPortID[7] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->coord || 
	(cx_coord_uniform <= ((cxLattice *) cxChkDat)->coord->coordType 
                         && ((cxLattice *) cxChkDat)->coord->coordType<= cx_coord_perimeter);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxLattice *) cxChkDat)->coord->coordType, 
				"cxCoordType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->coord->coordType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Coord Type", 
		    "->coord->coordType", 
		    portData, 
		    "cx_coord_uniform", 
		    "cx_coord_perimeter" );
      cxInputDataRelease( cxMDWPortID[7] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->coord || 
	(2 <= *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) ) 
                         && *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) )<= 3);
    if (!portOK) {
      sprintf( buf, "%d", *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) ) );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Num Coord Dimensions", 
		    "->coord->c.cx_coord_curvilinear.nCoordVar", 
		    portData, 
		    "2", 
		    "3" );
      cxInputDataRelease( cxMDWPortID[7] );
      cxModAlert( msg );
      return cx_err_error;
      }
  }
  cxChkDat  = ports[8];
  if (cxChkDat) {
    /* Only check optional port when it has data */
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxData *) 1) <= ((cxLattice *) cxChkDat)->data);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 3", 
		    "cxLattice", 
		    "Data Structure", 
		    "->data", 
		    portData, 
		    "((cxData *) 1)", 
		    "" );
      cxInputDataRelease( cxMDWPortID[8] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxCoord *) 1) <= ((cxLattice *) cxChkDat)->coord);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->coord );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 3", 
		    "cxLattice", 
		    "Coord Structure", 
		    "->coord", 
		    portData, 
		    "((cxCoord *) 1)", 
		    "" );
      cxInputDataRelease( cxMDWPortID[8] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (2 <= ((cxLattice *) cxChkDat)->nDim 
                         && ((cxLattice *) cxChkDat)->nDim<= 3);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->nDim );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 3", 
		    "cxLattice", 
		    "Num Dimensions", 
		    "->nDim", 
		    portData, 
		    "2", 
		    "3" );
      cxInputDataRelease( cxMDWPortID[8] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->data || 
	(1 <= ((cxLattice *) cxChkDat)->data->nDataVar);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data->nDataVar );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 3", 
		    "cxLattice", 
		    "Num Data Variables", 
		    "->data->nDataVar", 
		    portData, 
		    "1", 
		    "" );
      cxInputDataRelease( cxMDWPortID[8] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->data || 
	(cx_prim_byte <= ((cxLattice *) cxChkDat)->data->primType 
                         && ((cxLattice *) cxChkDat)->data->primType<= cx_prim_double);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxLattice *) cxChkDat)->data->primType, 
				"cxPrimType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data->primType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 3", 
		    "cxLattice", 
		    "Primitive Data Type", 
		    "->data->primType", 
		    portData, 
		    "cx_prim_byte", 
		    "cx_prim_double" );
      cxInputDataRelease( cxMDWPortID[8] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->coord || 
	(cx_coord_uniform <= ((cxLattice *) cxChkDat)->coord->coordType 
                         && ((cxLattice *) cxChkDat)->coord->coordType<= cx_coord_perimeter);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxLattice *) cxChkDat)->coord->coordType, 
				"cxCoordType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->coord->coordType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 3", 
		    "cxLattice", 
		    "Coord Type", 
		    "->coord->coordType", 
		    portData, 
		    "cx_coord_uniform", 
		    "cx_coord_perimeter" );
      cxInputDataRelease( cxMDWPortID[8] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->coord || 
	(2 <= *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) ) 
                         && *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) )<= 3);
    if (!portOK) {
      sprintf( buf, "%d", *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) ) );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 3", 
		    "cxLattice", 
		    "Num Coord Dimensions", 
		    "->coord->c.cx_coord_curvilinear.nCoordVar", 
		    portData, 
		    "2", 
		    "3" );
      cxInputDataRelease( cxMDWPortID[8] );
      cxModAlert( msg );
      return cx_err_error;
      }
  }

  return cx_err_none;
}
/*****************************************************/
/* Check Output ports against constraints in module resources. */
cxErrorCode cxPortCheckOut ( int portC, void *ports[], long *cxMDWPortID ) 
{
  cxErrorCode   ec;
  int           portOK;
  void         *cxChkDat;
  char          buf[128], *portData, *msg;


  /* Can't do port checking on alternate executables. */

  if (strcmp( "CoordCrop", cxModuleNameGet()) != NULL)
    return cx_err_none;
  /* Can't do port checking on variable # ports. */

  if (portC != 3)
    return cx_err_none;
  /* Checking contents of Output datasets. */
  cxChkDat  = ports[0];
  if (cxChkDat) {
    /* Only check optional port when it has data */
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxData *) 1) <= ((cxLattice *) cxChkDat)->data);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Data Structure", 
		    "->data", 
		    portData, 
		    "((cxData *) 1)", 
		    "" );
      cxOutputDataSet( cxMDWPortID[0], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxCoord *) 1) <= ((cxLattice *) cxChkDat)->coord);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->coord );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Coord Structure", 
		    "->coord", 
		    portData, 
		    "((cxCoord *) 1)", 
		    "" );
      cxOutputDataSet( cxMDWPortID[0], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (2 <= ((cxLattice *) cxChkDat)->nDim 
                         && ((cxLattice *) cxChkDat)->nDim<= 3);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->nDim );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Num Dimensions", 
		    "->nDim", 
		    portData, 
		    "2", 
		    "3" );
      cxOutputDataSet( cxMDWPortID[0], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->data || 
	(1 <= ((cxLattice *) cxChkDat)->data->nDataVar);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data->nDataVar );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Num Data Variables", 
		    "->data->nDataVar", 
		    portData, 
		    "1", 
		    "" );
      cxOutputDataSet( cxMDWPortID[0], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->data || 
	(cx_prim_byte <= ((cxLattice *) cxChkDat)->data->primType 
                         && ((cxLattice *) cxChkDat)->data->primType<= cx_prim_double);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxLattice *) cxChkDat)->data->primType, 
				"cxPrimType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data->primType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Primitive Data Type", 
		    "->data->primType", 
		    portData, 
		    "cx_prim_byte", 
		    "cx_prim_double" );
      cxOutputDataSet( cxMDWPortID[0], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->coord || 
	(cx_coord_uniform <= ((cxLattice *) cxChkDat)->coord->coordType 
                         && ((cxLattice *) cxChkDat)->coord->coordType<= cx_coord_perimeter);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxLattice *) cxChkDat)->coord->coordType, 
				"cxCoordType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->coord->coordType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Coord Type", 
		    "->coord->coordType", 
		    portData, 
		    "cx_coord_uniform", 
		    "cx_coord_perimeter" );
      cxOutputDataSet( cxMDWPortID[0], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->coord || 
	(2 <= *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) ) 
                         && *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) )<= 3);
    if (!portOK) {
      sprintf( buf, "%d", *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) ) );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Num Coord Dimensions", 
		    "->coord->c.cx_coord_curvilinear.nCoordVar", 
		    portData, 
		    "2", 
		    "3" );
      cxOutputDataSet( cxMDWPortID[0], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  }
  cxChkDat  = ports[1];
  if (cxChkDat) {
    /* Only check optional port when it has data */
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxData *) 1) <= ((cxLattice *) cxChkDat)->data);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Data Structure", 
		    "->data", 
		    portData, 
		    "((cxData *) 1)", 
		    "" );
      cxOutputDataSet( cxMDWPortID[1], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxCoord *) 1) <= ((cxLattice *) cxChkDat)->coord);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->coord );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Coord Structure", 
		    "->coord", 
		    portData, 
		    "((cxCoord *) 1)", 
		    "" );
      cxOutputDataSet( cxMDWPortID[1], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (2 <= ((cxLattice *) cxChkDat)->nDim 
                         && ((cxLattice *) cxChkDat)->nDim<= 3);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->nDim );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Num Dimensions", 
		    "->nDim", 
		    portData, 
		    "2", 
		    "3" );
      cxOutputDataSet( cxMDWPortID[1], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->data || 
	(1 <= ((cxLattice *) cxChkDat)->data->nDataVar);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data->nDataVar );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Num Data Variables", 
		    "->data->nDataVar", 
		    portData, 
		    "1", 
		    "" );
      cxOutputDataSet( cxMDWPortID[1], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->data || 
	(cx_prim_byte <= ((cxLattice *) cxChkDat)->data->primType 
                         && ((cxLattice *) cxChkDat)->data->primType<= cx_prim_double);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxLattice *) cxChkDat)->data->primType, 
				"cxPrimType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data->primType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Primitive Data Type", 
		    "->data->primType", 
		    portData, 
		    "cx_prim_byte", 
		    "cx_prim_double" );
      cxOutputDataSet( cxMDWPortID[1], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->coord || 
	(cx_coord_uniform <= ((cxLattice *) cxChkDat)->coord->coordType 
                         && ((cxLattice *) cxChkDat)->coord->coordType<= cx_coord_perimeter);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxLattice *) cxChkDat)->coord->coordType, 
				"cxCoordType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->coord->coordType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Coord Type", 
		    "->coord->coordType", 
		    portData, 
		    "cx_coord_uniform", 
		    "cx_coord_perimeter" );
      cxOutputDataSet( cxMDWPortID[1], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->coord || 
	(2 <= *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) ) 
                         && *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) )<= 3);
    if (!portOK) {
      sprintf( buf, "%d", *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) ) );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Num Coord Dimensions", 
		    "->coord->c.cx_coord_curvilinear.nCoordVar", 
		    portData, 
		    "2", 
		    "3" );
      cxOutputDataSet( cxMDWPortID[1], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  }
  cxChkDat  = ports[2];
  if (cxChkDat) {
    /* Only check optional port when it has data */
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxData *) 1) <= ((cxLattice *) cxChkDat)->data);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 3", 
		    "cxLattice", 
		    "Data Structure", 
		    "->data", 
		    portData, 
		    "((cxData *) 1)", 
		    "" );
      cxOutputDataSet( cxMDWPortID[2], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxCoord *) 1) <= ((cxLattice *) cxChkDat)->coord);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->coord );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 3", 
		    "cxLattice", 
		    "Coord Structure", 
		    "->coord", 
		    portData, 
		    "((cxCoord *) 1)", 
		    "" );
      cxOutputDataSet( cxMDWPortID[2], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (2 <= ((cxLattice *) cxChkDat)->nDim 
                         && ((cxLattice *) cxChkDat)->nDim<= 3);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->nDim );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 3", 
		    "cxLattice", 
		    "Num Dimensions", 
		    "->nDim", 
		    portData, 
		    "2", 
		    "3" );
      cxOutputDataSet( cxMDWPortID[2], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->data || 
	(1 <= ((cxLattice *) cxChkDat)->data->nDataVar);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data->nDataVar );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 3", 
		    "cxLattice", 
		    "Num Data Variables", 
		    "->data->nDataVar", 
		    portData, 
		    "1", 
		    "" );
      cxOutputDataSet( cxMDWPortID[2], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->data || 
	(cx_prim_byte <= ((cxLattice *) cxChkDat)->data->primType 
                         && ((cxLattice *) cxChkDat)->data->primType<= cx_prim_double);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxLattice *) cxChkDat)->data->primType, 
				"cxPrimType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data->primType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 3", 
		    "cxLattice", 
		    "Primitive Data Type", 
		    "->data->primType", 
		    portData, 
		    "cx_prim_byte", 
		    "cx_prim_double" );
      cxOutputDataSet( cxMDWPortID[2], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->coord || 
	(cx_coord_uniform <= ((cxLattice *) cxChkDat)->coord->coordType 
                         && ((cxLattice *) cxChkDat)->coord->coordType<= cx_coord_perimeter);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxLattice *) cxChkDat)->coord->coordType, 
				"cxCoordType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->coord->coordType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 3", 
		    "cxLattice", 
		    "Coord Type", 
		    "->coord->coordType", 
		    portData, 
		    "cx_coord_uniform", 
		    "cx_coord_perimeter" );
      cxOutputDataSet( cxMDWPortID[2], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->coord || 
	(2 <= *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) ) 
                         && *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) )<= 3);
    if (!portOK) {
      sprintf( buf, "%d", *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) ) );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 3", 
		    "cxLattice", 
		    "Num Coord Dimensions", 
		    "->coord->c.cx_coord_curvilinear.nCoordVar", 
		    portData, 
		    "2", 
		    "3" );
      cxOutputDataSet( cxMDWPortID[2], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  }

  return cx_err_none;
}

#ifdef __cplusplus
}
#endif

