/* ------------------------------------------- */
/*
 *   Author: James Phillips
 *           Department of Physics
 *           Marquette University
 *           Milwaukee, WI 53233
 *
 *   Purpose: Explorer module which crops uniform
 *            and perimeter lattices based on
 *            coordinates rather than indices.
 *
 *   Written for the David A. Yuen research group
 *   at the Minnesota Supercomputer Institute and
 *   Department of Geology and Geophysics, 
 *   University of Minnesota.  Christmas, 1992.
 *
 */
/* ------------------------------------------- */

#include <cx/DataTypes.h>
#include <cx/DataAccess.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#define MIN(X,Y) ((X)<(Y)?(X):(Y))
#define MAX(X,Y) ((X)>(Y)?(X):(Y))

#ifdef __cplusplus
	extern "C" {
#endif

void  swap(long *a, long *b)
{
   long temp;

   temp = *a;
   *a = *b;
   *b = temp;
}

  void 	coordcrop  (
    double 	  xMin, 
    double 	  xMax, 
    double 	  yMin, 
    double 	  yMax, 
    double 	  zMin, 
    double 	  zMax, 
    cxLattice    *    lat1In, 
    cxLattice    *  * lat1Out,
    cxLattice    *    lat2In, 
    cxLattice    *  * lat2Out,
    cxLattice    *    lat3In,
    cxLattice    *  * lat3Out)
{

   long nCoord;
   cxData *inData;
   char *indata;
   char *indata2;
   cxData *outData;
   char *outdata;
   cxCoord *inCoord;
   float *incoord;
   cxCoord *outCoord;
   float *outcoord;
   long m,n,p;
   long *dims;
   long outdims[3];
   long datasize;
   long nDim, nDataVar, nCoordVar;
   cxPrimType primType;
   cxCoordType coordType;
   int i,j,k;
   int iMin,iMax,jMin,jMax,kMin,kMax;
   int imin,imax,jmin,jmax,kmin,kmax;
   float *xcoord,*ycoord,*zcoord;

   cxLattice *inLats[3];
   cxLattice *outLats[3];
   int pchanged;

   *lat1Out = NULL;
   *lat2Out = NULL;
   *lat3Out = NULL;

   if ( xMin > xMax || yMin > yMax || zMin > zMax ) return;

   pchanged = (
      cxInputDataChanged(cxInputPortOpen("x Min")) ||
      cxInputDataChanged(cxInputPortOpen("x Max")) ||
      cxInputDataChanged(cxInputPortOpen("y Min")) ||
      cxInputDataChanged(cxInputPortOpen("y Max")) ||
      cxInputDataChanged(cxInputPortOpen("z Min")) ||
      cxInputDataChanged(cxInputPortOpen("z Max")) );

   if ( cxInputDataChanged(cxInputPortOpen("Lattice 1")) || pchanged )
      inLats[0] = lat1In; else inLats[0] = NULL;
   if ( cxInputDataChanged(cxInputPortOpen("Lattice 2")) || pchanged )
      inLats[1] = lat2In; else inLats[1] = NULL;
   if ( cxInputDataChanged(cxInputPortOpen("Lattice 3")) || pchanged )
      inLats[2] = lat3In; else inLats[2] = NULL;

   /* Copy lattices. */

   for(n=0;n<3;n++) if(inLats[n]) {

      cxLatPtrGet(inLats[n],&inData,&indata,&inCoord,&incoord);
      cxLatDescGet(inLats[n],&nDim,&dims,
                   NULL,&nDataVar,&primType,
                   NULL,&nCoordVar,&coordType);
      datasize = nDataVar * cxDataPrimSize(inData);

      if ( coordType == cx_coord_curvilinear || nCoordVar != nDim ) return;
      if ( coordType == cx_coord_uniform && nDim == 2 ) {
         imin = (dims[0]-1)*(xMin-incoord[0])/(incoord[1]-incoord[0]);
         imax = (dims[0]-1)*(xMax-incoord[0])/(incoord[1]-incoord[0]);
         jmin = (dims[1]-1)*(yMin-incoord[2])/(incoord[3]-incoord[2]);
         jmax = (dims[1]-1)*(yMax-incoord[2])/(incoord[3]-incoord[2]);
         if(imin>imax) {
         iMin = imax = MIN(MAX(imax,0),dims[0]-1);
         iMax = imin = MIN(MAX(imin,0),dims[0]-1);
         } else {
         iMax = imax = MIN(MAX(imax,0),dims[0]-1);
         iMin = imin = MIN(MAX(imin,0),dims[0]-1);
         }
         if(jmin>jmax) {
         jMin = jmax = MIN(MAX(jmax,0),dims[1]-1);
         jMax = jmin = MIN(MAX(jmin,0),dims[1]-1);
         } else {
         jMax = jmax = MIN(MAX(jmax,0),dims[1]-1);
         jMin = jmin = MIN(MAX(jmin,0),dims[1]-1);
         }
         outdims[0] = iMax - iMin + 1;
         outdims[1] = jMax - jMin + 1;
         outLats[n] = cxLatNew(nDim, outdims, nDataVar, primType,
                               nCoordVar, coordType);
         if(cxDataAllocErrorGet()) {
            for(j=0;j<n;j++) if(outLats[j]) cxDataRefDec(outLats[j]);
            return;
         } 
         cxLatPtrGet(outLats[n],&outData,&outdata,&outCoord,&outcoord);
         for(j=jMin,indata+=jMin*dims[0]*datasize;j<=jMax;
             j++,indata+=dims[0]*datasize,outdata+=outdims[0]*datasize)
            memcpy(outdata,indata+iMin*datasize,outdims[0]*datasize);
         outcoord[0] = incoord[0] + iMin*(incoord[1]-incoord[0])/(dims[0]-1);
         outcoord[1] = incoord[0] + iMax*(incoord[1]-incoord[0])/(dims[0]-1);
         outcoord[2] = incoord[2] + jMin*(incoord[3]-incoord[2])/(dims[1]-1);
         outcoord[3] = incoord[2] + jMax*(incoord[3]-incoord[2])/(dims[1]-1);
      }
      if ( coordType == cx_coord_uniform && nDim == 3 ) {
         imin = (dims[0]-1)*(xMin-incoord[0])/(incoord[1]-incoord[0]);
         imax = (dims[0]-1)*(xMax-incoord[0])/(incoord[1]-incoord[0]);
         jmin = (dims[1]-1)*(yMin-incoord[2])/(incoord[3]-incoord[2]);
         jmax = (dims[1]-1)*(yMax-incoord[2])/(incoord[3]-incoord[2]);
         kmin = (dims[2]-1)*(zMin-incoord[4])/(incoord[5]-incoord[4]);
         kmax = (dims[2]-1)*(zMax-incoord[4])/(incoord[5]-incoord[4]);
         if(imin>imax) {
         iMin = imax = MIN(MAX(imax,0),dims[0]-1);
         iMax = imin = MIN(MAX(imin,0),dims[0]-1);
         } else {
         iMax = imax = MIN(MAX(imax,0),dims[0]-1);
         iMin = imin = MIN(MAX(imin,0),dims[0]-1);
         }
         if(jmin>jmax) {
         jMin = jmax = MIN(MAX(jmax,0),dims[1]-1);
         jMax = jmin = MIN(MAX(jmin,0),dims[1]-1);
         } else {
         jMax = jmax = MIN(MAX(jmax,0),dims[1]-1);
         jMin = jmin = MIN(MAX(jmin,0),dims[1]-1);
         }
         if(kmin>kmax) {
         kMin = kmax = MIN(MAX(kmax,0),dims[2]-1);
         kMax = kmin = MIN(MAX(kmin,0),dims[2]-1);
         } else {
         kMax = kmax = MIN(MAX(kmax,0),dims[2]-1);
         kMin = kmin = MIN(MAX(kmin,0),dims[2]-1);
         }
         outdims[0] = iMax - iMin + 1;
         outdims[1] = jMax - jMin + 1;
         outdims[2] = kMax - kMin + 1;
         outLats[n] = cxLatNew(nDim, outdims, nDataVar, primType,
                               nCoordVar, coordType);
         if(cxDataAllocErrorGet()) {
            for(j=0;j<n;j++) if(outLats[j]) cxDataRefDec(outLats[j]);
            return;
         } 
         cxLatPtrGet(outLats[n],&outData,&outdata,&outCoord,&outcoord);
         for(k=kMin,indata+=kMin*dims[1]*dims[0]*datasize;k<=kMax;
             k++,indata+=dims[1]*dims[0]*datasize)
            for(j=jMin,indata2=indata+jMin*dims[0]*datasize;j<=jMax;
                j++,indata2+=dims[0]*datasize,outdata+=outdims[0]*datasize)
               memcpy(outdata,indata2+iMin*datasize,outdims[0]*datasize);
         outcoord[0] = incoord[0] + iMin*(incoord[1]-incoord[0])/(dims[0]-1);
         outcoord[1] = incoord[0] + iMax*(incoord[1]-incoord[0])/(dims[0]-1);
         outcoord[2] = incoord[2] + jMin*(incoord[3]-incoord[2])/(dims[1]-1);
         outcoord[3] = incoord[2] + jMax*(incoord[3]-incoord[2])/(dims[1]-1);
         outcoord[4] = incoord[4] + kMin*(incoord[5]-incoord[4])/(dims[2]-1);
         outcoord[5] = incoord[4] + kMax*(incoord[5]-incoord[4])/(dims[2]-1);
      }
      if ( coordType == cx_coord_perimeter && nDim == 2 ) {
         xcoord = incoord;
         ycoord = xcoord + dims[0];
         for(iMin=j=0;j<dims[0];
            iMin=(fabs(xcoord[iMin]-xMin)<fabs(xcoord[j]-xMin)?iMin:j),j++);
         for(iMax=j=0;j<dims[0];
            iMax=(fabs(xcoord[iMax]-xMax)<fabs(xcoord[j]-xMax)?iMax:j),j++);
         for(jMin=j=0;j<dims[1];
            jMin=(fabs(ycoord[jMin]-yMin)<fabs(ycoord[j]-yMin)?jMin:j),j++);
         for(jMax=j=0;j<dims[1];
            jMax=(fabs(ycoord[jMax]-yMax)<fabs(ycoord[j]-yMax)?jMax:j),j++);
         if ( iMin > iMax ) swap(&iMin,&iMax);
         if ( jMin > jMax ) swap(&jMin,&jMax);
         outdims[0] = iMax - iMin + 1;
         outdims[1] = jMax - jMin + 1;
         outLats[n] = cxLatNew(nDim, outdims, nDataVar, primType,
                               nCoordVar, coordType);
         if(cxDataAllocErrorGet()) {
            for(j=0;j<n;j++) if(outLats[j]) cxDataRefDec(outLats[j]);
            return;
         } 
         cxLatPtrGet(outLats[n],&outData,&outdata,&outCoord,&outcoord);
         for(j=jMin,indata+=jMin*dims[0]*datasize;j<=jMax;
             j++,indata+=dims[0]*datasize,outdata+=outdims[0]*datasize)
            memcpy(outdata,indata+iMin*datasize,outdims[0]*datasize);
         for(j=0,m=0;j+iMin<=iMax;outcoord[m]=xcoord[j+iMin],j++,m++);
         for(j=0;j+jMin<=jMax;outcoord[m]=ycoord[j+jMin],j++,m++);
      }
      if ( coordType == cx_coord_perimeter && nDim == 3 ) {
         xcoord = incoord;
         ycoord = xcoord + dims[0];
         zcoord = ycoord + dims[1];
         for(iMin=j=0;j<dims[0];
            iMin=(fabs(xcoord[iMin]-xMin)<fabs(xcoord[j]-xMin)?iMin:j),j++);
         for(iMax=j=0;j<dims[0];
            iMax=(fabs(xcoord[iMax]-xMax)<fabs(xcoord[j]-xMax)?iMax:j),j++);
         for(jMin=j=0;j<dims[1];
            jMin=(fabs(ycoord[jMin]-yMin)<fabs(ycoord[j]-yMin)?jMin:j),j++);
         for(jMax=j=0;j<dims[1];
            jMax=(fabs(ycoord[jMax]-yMax)<fabs(ycoord[j]-yMax)?jMax:j),j++);
         for(kMin=j=0;j<dims[2];
            kMin=(fabs(zcoord[kMin]-zMin)<fabs(zcoord[j]-zMin)?kMin:j),j++);
         for(kMax=j=0;j<dims[2];
            kMax=(fabs(zcoord[kMax]-zMax)<fabs(zcoord[j]-zMax)?kMax:j),j++);
         if ( iMin > iMax ) swap(&iMin,&iMax);
         if ( jMin > jMax ) swap(&jMin,&jMax);
         if ( kMin > kMax ) swap(&kMin,&kMax);
         outdims[0] = iMax - iMin + 1;
         outdims[1] = jMax - jMin + 1;
         outdims[2] = kMax - kMin + 1;
         outLats[n] = cxLatNew(nDim, outdims, nDataVar, primType,
                               nCoordVar, coordType);
         if(cxDataAllocErrorGet()) {
            for(j=0;j<n;j++) if(outLats[j]) cxDataRefDec(outLats[j]);
            return;
         } 
         cxLatPtrGet(outLats[n],&outData,&outdata,&outCoord,&outcoord);
         for(k=kMin,indata+=kMin*dims[1]*dims[0]*datasize;k<=kMax;
             k++,indata+=dims[1]*dims[0]*datasize)
            for(j=jMin,indata2=indata+jMin*dims[0]*datasize;j<=jMax;
                j++,indata2+=dims[0]*datasize,outdata+=outdims[0]*datasize)
               memcpy(outdata,indata2+iMin*datasize,outdims[0]*datasize);
         for(j=0,m=0;j+iMin<=iMax;outcoord[m]=xcoord[j+iMin],j++,m++);
         for(j=0;j+jMin<=jMax;outcoord[m]=ycoord[j+jMin],j++,m++);
         for(j=0;j+kMin<=kMax;outcoord[m]=zcoord[j+kMin],j++,m++);
      }

   } else outLats[n] = NULL;

   *lat1Out = outLats[0];
   *lat2Out = outLats[1];
   *lat3Out = outLats[2];

   return;

}

#ifdef __cplusplus
}
#endif
/* ------------------------------------------- */
