def pro_res_nm_db():
 return ['ALA','GLY','VAL','ILE','LEU','PHE','TYR',\
         'TRP','ASN','GLN','ASP','GLU','LYS','ARG',\
         'ACE','NMR','PRO','DPR','SER','CYS','MET',\
         'HIS','HSD','HSE','HSH','ASPH','GLUH','THR','CYSH','NLE']

def sol_res_nm_db():
 return ['SOL','TIP','SOD','CLA','NA','CL','MG']

def lip_res_nm_db():
 return ['POPC','DPPC','POPE','DPPE']

def rna_res_nm_db():
 return ['RA','RU','RC','RG']



def pro_acc_db():
 return [['C','O'],\
       ['CG','OD1'],['CG','OD2'],\
       ['CD','OE1'],['CD','OE2'],\
       ['CG','ND1'],['CD2','NE2']]

def charge_res_db():
 return {\
  'ASP':-1,\
  'GLU':-1,\
  'LYS':1,\
  'ARG':1,\
  'HISH':1\
 }

def pro_donor_db():
 return [['H','N'],\
       ['HD21','ND2'],['HD22','ND2'],\
       ['HE21','NE2'],['HE22','NE2'],\
       ['HD1','ND1'],['HE2','NE2'],['HE1','NE1']]
#mapping rule from all atom models to coarse-grained models
#only for small molecules that have one residue 
def aa2cg_db():
 """
 Return database, name_list of database
 """
 db=[]
 db.append(['POPC','POPC',\
           [
           ["NC3",["N"]],\
           ["PO4",["C11","O13","O12","O14","O11","C1"]],\
           ["GL1",["O22","O21","C2","C21"]],\
           ["GL2",["O32","O31","C3","C31"]],\
           ["C1A",["C32","C33","C34","C35"]],\
           ["C2A",["C36","C37","C38"]],\
           ["C3A",["C39","C310","C311","C312"]],\
           ["C4A",["C313","C314","C315","C316"]],\
           ["C1B",["C22","C23","C24","C25"]],\
           ["C2B",["C26","C27","C28"]],\
           ["D3B",["C29","C210"]],\
           ["C4B",["C211","C212","C213","C214"]],\
           ["C5B",["C215","C216","C217","C218"]]\
           ]])

 db.append(['POPE','POPE',\
           [
           ["NH3",["N"]],\
           ["PO4",["C11","O13","O12","O14","O11","C1"]],\
           ["GL1",["O22","O21","C2","C21"]],\
           ["GL2",["O32","O31","C3","C31"]],\
           ["C1A",["C32","C33","C34","C35"]],\
           ["C2A",["C36","C37","C38"]],\
           ["C3A",["C39","C310","C311","C312"]],\
           ["C4A",["C313","C314","C315","C316"]],\
           ["C1B",["C22","C23","C24","C25"]],\
           ["C2B",["C26","C27","C28"]],\
           ["D3B",["C29","C210"]],\
           ["C4B",["C211","C212","C213","C214"]],\
           ["C5B",["C215","C216","C217","C218"]]\
           ]])

 db.append(['CL','CL-',\
           [
           ["CL-",["CL"]]\
           ]])

 db.append(['CLA','CL-',\
           [
           ["CL-",["CLA"]]\
           ]])

 db.append(['NA','NA+',\
           [
           ["NA+",["NA"]]\
           ]])

 db.append(['SOD','NA+',\
           [
           ["NA+",["SOD"]]\
           ]])

 db.append(['MG','MG+',\
           [
           ["MG+",["MG"]]\
           ]])


 db.append(['RA','RA',\
            [
	    ['P',['P',"O1P","O2P","O5'","O3'"]],\
	    ['C1',["C5'","C4'","C3'","O4'"]],\
	    ['C2',["C2'","C1'","O2'"]],\
	    ['C3',["N9","C8","N7"]],\
	    ['C4',['C5','C4','N3','C2']],\
	    ['C5',['N1','C6','N6']]\
	    ]])

 db.append(['RU','RU',\
            [
            ['P',['P',"O1P","O2P","O5'","O3'"]],\
            ['C1',["C5'","C4'","C3'","O4'"]],\
            ['C2',["C2'","C1'","O2'"]],\
            ['C3',["N1","C2","O2","N3"]],\
            ['C4',['C6','C5','C4','O4']]\
            ]])

 db.append(['RC','RC',\
            [
            ['P',['P',"O1P","O2P","O5'","O3'"]],\
            ['C1',["C5'","C4'","C3'","O4'"]],\
            ['C2',["C2'","C1'","O2'"]],\
            ['C3',["N1","C2","O2","N3"]],\
            ['C4',['C6','C5','C4','N4']]\
            ]])


 db.append(['RG','RG',\
            [
            ['P',['P',"O1P","O2P","O5'","O3'"]],\
            ['C1',["C5'","C4'","C3'","O4'"]],\
            ['C2',["C2'","C1'","O2'"]],\
            ['C3',["N9","C8","N7"]],\
            ['C4',['C5','C6','O6','N1']],\
            ['C5',['C4','N3','C2','N2']]\
            ]])

#========
#Please insert new 
#mapping rules here
#========
#example:
# db.append([AA-resname,CG-resname,\
#           [
#           [CG-atom1,[list of AA atoms mapping to CG-atom1]]\
#           ]])
#**make sure in topology files, CG-residues are defined


#========
 return db, [i[0] for i in db]

#=======

def aa2berger_db():
 """
 Return database, name_list of database
 """
 db=[]

 db.append(['POPC','POPC',\
           [
           ['C1',['C13']],\
           ['C2',['C14']],\
           ['C3',['C15']],\
           ['N4',['N']],\
           ['C5',['C12']],\
           ['C6',['C11']],\
           ['O7',['O12']],\
           ['P8',['P']],\
           ['O9',['O13']],\
           ['O10',['O14']],\
           ['O11',['O11']],\
           ['C12',['C1']],\
           ['C13',['C2']],\
           ['O14',['O21']],\
           ['C15',['C21']],\
           ['O16',['O22']],\
           ['C17',['C22']],\
           ['C18',['C23']],\
           ['C19',['C24']],\
           ['C20',['C25']],\
           ['C21',['C26']],\
           ['C22',['C27']],\
           ['C23',['C28']],\
           ['C24',['C29']],\
           ['C25',['C210']],\
           ['C26',['C211']],\
           ['C27',['C212']],\
           ['C28',['C213']],\
           ['C29',['C214']],\
           ['C30',['C215']],\
           ['C31',['C216']],\
           ['CA1',['C217']],\
           ['CA2',['C218']],\
           ['C32',['C3']],\
           ['O33',['O31']],\
           ['C34',['C31']],\
           ['O35',['O32']],\
           ['C36',['C32']],\
           ['C37',['C33']],\
           ['C38',['C34']],\
           ['C39',['C35']],\
           ['C40',['C36']],\
           ['C41',['C37']],\
           ['C42',['C38']],\
           ['C43',['C39']],\
           ['C44',['C310']],\
           ['C45',['C311']],\
           ['C46',['C312']],\
           ['C47',['C313']],\
           ['C48',['C314']],\
           ['C49',['C315']],\
           ['C50',['C316']]\
           ]])


 return db, [i[0] for i in db]


def top_gmx_load_rules(ff_obj):
 return  {\
       'bonds':[ff_obj.bonds,[0,1],ff_obj.bond_params,[3,4],2,{}],\
       'exclusions':[ff_obj.exclusions,[0,1],ff_obj.exclusion_params,[0,1],0,{}],\
       'angles':[ff_obj.angles,[0,1,2],ff_obj.angle_params,[4,5],3,{}],\
       #dihedrals can be redirected to imprs if dih type is 2
       'dihedrals':[ff_obj.dihes,[0,1,2,3],ff_obj.dihe_params,[5,6,7],\
                    4,{2:'imprs'}],\
       'pairs':[ff_obj.pairs,[0,1],ff_obj.pair_params,[3,4],2,{}],\
       'imprs':[ff_obj.imprs,[0,1,2,3], ff_obj.impr_params,[5,6],4, {}]\
              }

def gmx_top_param_connection(ff_obj):
#        ref to name field  ref to params mapping param  conversion unit
# for parameter fields, in FF, its ith term is top_param[p_field[i]]*convert[i]
# if p_field[i]<0, ith term should be convert[i]
# where                top_param          p_field         convert
#                         v                 v              v
 return {\
 'BONDS':[ff_obj.bonds,ff_obj.bond_params, [1,0],   [1./2./100./4.184, 10.]],\
 'ANGLES':[ff_obj.angles,ff_obj.angle_params, [1,0],   [1./2./4.184, 1.]],\
 'DIHEDRALS':[ff_obj.dihes,ff_obj.dihe_params, [1,2,0],   [1./4.184, 1 , 1.]],\
 'IMPROPER':[ff_obj.imprs,ff_obj.impr_params, [1,-1,0],   [1./2./4.184, 0, 1.]]\
 #'NBFIXPAIR':[ff_obj.nbfixs, ff_obj.nbfix_params, [1,0], []]\
 }

def param_gmx_2_charmm (ff_obj):
#if p_field[i]==-1, ith term should be convert[i]
#if p_field[i]==-2, ith term keeps unchanged
 return {\
###comment out part that doesnot need params
'bonds':[ff_obj.bonds, ff_obj.bond_params,'BONDS', [1,0], [1./2./100./4.184, 10.]],\
'angles':[ff_obj.angles, ff_obj.angle_params,'ANGLES',[1,0],[1./2./4.184, 1.]],\
'dihedrals':[ff_obj.dihes, ff_obj.dihe_params,'DIHEDRALS',[1,2,0],[1./4.184, 1, 1.]],\
'imprs':[ff_obj.imprs, ff_obj.impr_params,'IMPROPER',[1,-1,0],[1./2./4.184, 0, 1.]],\
#'exclusions':[ff_obj.exclusion_params,'NBFIX', [-2,-2], [0,0]],\
###commont out follwoing for debugging,
###if the bugs are not related to pairs
'pairs':[ff_obj.pairs, ff_obj.pair_params, 'NBFIX',[1, 0],[1.e+12/4.184, 1.e+6/4.184]]\
}


#used to convert parameters from one format to charmm format
def param_namd_2_charmm (ff_obj):
#if p_field[i]==-1, ith term should be convert[i]
#if p_field[i]==-2, ith term keeps unchanged
 return {\
###comment out part that doesnot need params
'bonds':[ff_obj.bonds, ff_obj.bond_params,'BONDS', [0,1], [1., 1.]],\
'angles':[ff_obj.angles, ff_obj.angle_params,'ANGLES',[0,1],[1., 1.]],\
'dihedrals':[ff_obj.dihes, ff_obj.dihe_params,'DIHEDRALS',[0,1,2],[1., 1, 1.]],\
'imprs':[ff_obj.imprs, ff_obj.impr_params,'IMPROPER',[0,-1,2],[1., 0, 1.]],\
#'exclusions':[ff_obj.exclusion_params,'NBFIX', [-2,-2], [0,0]],\
###commont out follwoing for debugging,
###if the bugs are not related to pairs
'pairs':[ff_obj.pairs, ff_obj.pair_params, 'NBFIX',[0, 1],[1., 1.]]\
}




def load_param_charmm_rule(ff_obj):
#                   number of names      col idx   data type for each col
#                                                    1 float 0 int
 return {\
 'BONDS':[ff_obj.bonds,2, ff_obj.bond_params,[2,3],[1,1]],\
 'ANGLES':[ff_obj.angles,3, ff_obj.angle_params,[3,4],[1,1]],\
 'DIHEDRALS':[ff_obj.dihes,4, ff_obj.dihe_params,[4,5,6],[1,0,1]],\
 'IMPROPER':[ff_obj.imprs,4, ff_obj.impr_params,[4,5,6],[1,0,1]],\
 'NONBONDED':[ff_obj.nbs,1, ff_obj.nb_params,[1,2,3,4,5,6],[1,1,1,1,1,1]],\
 'NBFIX':[ff_obj.nbfixs,2, ff_obj.nbfix_params,[2,3,4,5],[1,1,1,1]]\
 }

def load_param_gmx_rule(ff_obj):
#                   number of names      col idx   data type for each col
#                                                    1 float 0 int
 return {\
 'atomtypes':[ff_obj.gmx_atoms,1, ff_obj.gmx_atom_params,[1,2,4,5],[1,1,1,1],3,{}],\
 'nonbond-params':[ff_obj.gmx_nbs,2, ff_obj.gmx_nb_params,[3,4],[1,1],2,{}],\
# 'nonbond_params':[ff_obj.gmx_nbs,2, ff_obj.gmx_nb_params,[3,4],[1,1],2,{}],\
 'angletypes':[ff_obj.gmx_angles,3, ff_obj.gmx_angle_params,[4,5],[1,1],3 ,{} ],\
 'bondtypes':[ff_obj.gmx_bonds, 2, ff_obj.gmx_bond_params, [3,4],[1,1], 2,{}],\
 'pairtypes':[ff_obj.gmx_pairs,2, ff_obj.gmx_pair_params,[3,4],[1,1],2,{}],\
 'dihedraltypes':[ff_obj.gmx_dihes,2, ff_obj.gmx_dihe_params,[3,4,5],[1,1,0],2,{'3':'URdihe'}],\
 'URdihe':[ff_obj.gmx_urdihes,2, ff_obj.gmx_urdihe_params,[3,4,5,6,7,8],[1,1,1,1,1,1],2,{}]\
 }


def load_psf_rule(psf):
 return {\
'!NATO':[psf.load_atom, []],\
'!NTIT':[None, []],\
'!NBON':[psf.load_tuple, [2,psf.bonds, psf.bond_params]],\
'!NTHE':[psf.load_tuple, [3, psf.angles, psf.angle_params]],\
'!NPHI':[psf.load_tuple, [4, psf.dihes, psf.dihe_params]],\
'!NIMP':[psf.load_tuple, [4, psf.imprs, psf.impr_params]],\
'!NDON':[None, []],\
'!NACC':[None, []],\
'!NMOD':[psf.load_modp, [psf.modpff]],\
'!NNB':[psf.load_nnb, []],\
'!NGRP':[None, []]\
}



def atom_hybrid_rule():
 return {\
#atomnm : [allow to get negative?. max connectivity]
 'C':['no', 4],\
 'N':['yes',3],\
 'O':['no',2],\
 'S':['no',2],\
 'P':['no',4],\
 'H':['no',1]\
 }



def amber_atom_type_rule():


 Csp3=[\
  [0,[['X','X','X','X']],'CT']\
 ]

 Csp2cyl =[\
  0,[['C','N','O'],['C','C','O'],['C','O','O']],'C'\
 ]

 Csp2aro=[\
 2,[['Csp2','Csp2','X'],['Csp2','Nsp2','X'],['Nsp2','Nsp2','X']],\
 ['CA','CB','CC','CD','CK','CM','CN','CQ','CR','CV','CW','CS']\
 ]

 Csp2=[Csp2cyl, Csp2aro]


 Csp1=[\
 [0,[['N','C']],'CY'],\
 [0,[['X','X']],'CZ']\
 ]

 Hsp3=[\
 [0,[['N']],'H'],\
 [3,[['Csp3']],['HC','H1','H2','H3']],\
 [3,[['Csp2']],['HA','H4','H5']],\
 [0,[['O']],'HO'],\
 [0,[['S']],'HS'],\
 [1,[['Csp1']],'HZ']\
 ]

 Namide=[\
 4,['Csp2','X'],{'Csp2':[['Osp2','X','X']]},'N'\
 ]

 Nsp2=[\
 Namide,\
 [2,[['Csp2','X']],['NA','NB','NC','N2']]
 ]

 Nsp3=[\
 [0,[['X','X','X','X']],'N3'],\
 [0,[['X','X','X']],'NT']\
 ]

 Nsp1=[\
 [1,[['Csp1']],'NY']\
 ]

 Ocyl=[\
 4,['Csp2'],{'Csp2':[['Osp2','Csp3','Csp3'],['Osp2','Nsp2','Csp3'],['Osp2','Osp3','X']]},'O'\
 ]

 Ocxy=[\
 4,['Csp2'],{'Csp2':[['Osp2','Osp2','X']]},'O2'\
 ]

 Ophos=[\
 0,[['P']],'O2'\
 ]

 Osp2=[\
 Ocyl,\
 Ocxy,\
 Ophos\
 ]

 Osp3=[\
 [0,[['C','H']],'OH'],\
 [0,[['C','X']],'OS']\
 ]

 Psp3=[\
 [0,[['X','X','X','X']],'P']\
 ]

 Ssp3=[\
 [0,[['C','H']],'SH'],\
 [0,[['X','X']],'S']\
 ]

 return {\
 'Csp3':Csp3,\
 'Csp2':Csp2,\
 'Csp1':Csp1,\
 'Hsp3':Hsp3,\
 'Nsp2':Nsp2,\
 'Nsp3':Nsp3,\
 'Nsp1':Nsp1,\
 'Osp2':Osp2,\
 'Osp3':Osp3,\
 'Psp3':Psp3,\
 'Ssp3':Ssp3\
 }
