import sys
import helper
import readFF 
import readTop

#comparison between two topology paramteres

def comp_toppar(top1, top2):
 topp1=toppar(None, None, top1)
 topp2=toppar(None, None, top2)
 toppar1= topp1.get_toppar()
 toppar2= topp2.get_toppar()
 all_term1= topp1.get_term_list()
 all_term2= topp2.get_term_list()
 if not all([i in all_term2 for i in all_term1]) or\
    not all([i in all_term1 for i in all_term2]):
  print all_term1,all_term2,'dont match'
  return False

 for ti,topi in zip(all_term1, toppar1):
  if not comp_toppar_sec(topi, toppar2[all_term2.index(ti)], ti):
   #return False
   pass

 return True


def comp_toppar_sec(top1, top2, term):
 if top1[0]!=top2[0]:
  print 'top paramters for',top1[0], top2[0],'cannot be compared'
  return False

 #assuming within each top[1], no repeat idxtuples
 #this is true if top come from toppar class
 #[1] for idxtuple [2] typtuple [3] parlist
 #each idxtuple is self sorted
 for ti,typi,pari in zip(top1[1], top1[2], top1[3]):  
  if not ti in top2[1]:
   print term,ti, typi, 'not found in the second topology'
   return False
  else:
   idx= top2[1].index(ti)
   if not comp_list(pari, top2[3][idx]):
    print term,ti, typi,'has paramters',pari,', different from',\
    top2[3][idx],'in the second topology.'
    return False
   top2[1].pop(idx)
   top2[2].pop(idx)
   top2[3].pop(idx) 
 #if something remain in top2, that must not be in top1
 left=False
 for ti, typi, pari in zip(top2[1], top2[2], top2[3]):  
  print term, ti, typi, pari,'not found in the first topology'
  left=True
 if left: return False

 return True


def comp_list(la, lb):
 la.sort()
 lb.sort()
 if len(la)!=len(lb): return False
 for ia, ib in zip(la, lb):
  if len(ia)!=len(ib): return False
  #print ia,ib

  #for a,b in zip(ia,ib):  helper.isdiff_float(a,b)

  if not all([not helper.isdiff_float(a,b,1e-20,1e-3) for a,b in zip(ia, ib)]):
   #print 'err'
   return False

 return True

#Class for topology paramters
class toppar:

 def __init__(self, fnm=None, new_toppar=None, copy_toppar=None):
  self.__toppar = []
  self.__temptoppar = None
  if not new_toppar is None:
   self.__temptoppar = new_toppar
  if not fnm is None:
   self.__load_toppar_from_file(fnm)

  if not copy_toppar==None:
   self.__copy_toppar(copy_toppar)

  if not self.__temptoppar is None:
   self.__organizeToppar()

 def get_toppar(self):
  return self.__toppar

 def __copy_toppar(self, ctoppar):
  for ti in ctoppar.get_toppar():
   self.__toppar.append(\
   [\
    ti[0],\
    [i[:] for i in ti[1]],\
    [i[:] for i in ti[2]],\
    [[j[:] for j in i] for i in ti[3]]\
   ]\
   )
 #mapfunc has following form
 #mapfunc(idxtuple) new idxtuple
 def remap_idx(self, mapfunc):
  for ti in self.__toppar:
   for idx,ii in enumerate(ti[1]):
    #print ii,
    
    ti[1][idx]= mapfunc(ii)
    
    #print ii

 def __load_toppar_from_file(self, fnm):
  return

 def get_term_list(self):
  return [i[0] for i in self.__toppar]

 def __organizeToppar(self):
  #all_terms = [i[0] for i in self.__temptoppar]
  for ter in self.__temptoppar.keys():
   term = ter
   ti = self.__temptoppar[ter]
   nmlist = ti[0]
   typlist = ti[1]
   parlist = ti[2]
   __newnm=[]
   __newtyp=[]
   __newpar =[]
   for ni, tpi, pari in zip(nmlist, typlist, parlist):
    if ni[0]>ni[-1]: ni.reverse()
    #print ni, tpi, pari
    if not ni in __newnm:
     __newnm.append(ni)
     __newtyp.append(tpi)
     __newpar.append([])

    idx= __newnm.index(ni)
    for ppi in pari:
     __newpar[idx].append(ppi[:])
    
   self.__toppar.append([term, \
    __newnm, __newtyp, __newpar])

 def __load_toppar_from_file(self, fnm):
  __newterm=[]
  #__newnmlist=[]
  #__newtyplist=[]
  #__newparlist=[]
  
  for ti in self.__toppar:
   if not ti[0] in __newterm:
    __newterm.append(ti[0])
    #__newnmlist.append(ti[1])
    #__newtyplist.append(ti[2])
    #__newparlist.append(ti[3])

  f=open(fnm,'r')
  for rl in f:
   srl=rl[:-1].split()
   if len(srl)==0: continue

   if '$' in rl: #a paramter line
    __newparlist[idx_entry].append(\
    [float(i) for i in srl[1:]]
    )
    continue
   else: #an index line
    term=srl[0]
    if not term in __newterm:
     __newterm.append(term)
     self.__toppar.append([term, [], [], []])
     
    idx_term= __newterm.index(term)
    __newnmlist = self.__toppar[idx_term][1]
    __newtyplist = self.__toppar[idx_term][2]
    __newparlist = self.__toppar[idx_term][3]

    #get nm
    srl_nm= srl[srl.index('nm')+1:srl.index('typ')]
    srl_typ= srl[srl.index('typ')+1:]
    if srl_nm[0]>srl_nm[-1]: srl_nm.reverse()
    if not srl_nm in __newnmlist:
     __newnmlist.append(srl_nm[:])
     __newtyplist.append(srl_typ[:])
     __newparlist.append([])

    idx_entry= __newnmlist.index(srl_nm)

  f.close() 
  
 def show(self):
  for ti in self.__toppar:
   
   #print ti[0],'nm',
   for ni, tpi, pari in zip(ti[1], ti[2], ti[3]):
    print ti[0],'nm',
    for i in ni: print i,
    print 'typ', 
    for i in tpi: print i,
    print 

    for i in pari:
     print '$',
     for j in i: print j,
     print

#end of toppar class

########################################################
#ouput all parameters needed by a input topology       #
#given a force field file                              #
#load_param_rule, provide how the force field is loaded#
#top2param_rule, provide how param in top is converted #
#into force field format, which part of top            #
#will be paramterized                                  #
#in top, for every entry, it hmust be as follows:      #
#[idxa,idxb,idxc....] [parameters] idx can be any type #
#also top has a method gettypetuple([idx])             #
#that return [typa, typb...]                           #
########################################################
def topparameters(top, ff,\
 load_param_rule, top2param_rule, verbose=False ):

 g_param = Top2Param(\
 ff, load_param_rule\
 )

#top.show()

######################################################
#exmaple to read out all the parameters of a topology#
#from topology and  force field                      #
######################################################
 topparam=[]
 topterm=[]
 t_lr = top2param_rule(top)
 for i in t_lr.keys():
  ti = t_lr[i]
  term = ti[2]
  p_field = ti[3]
  convert=ti[4]
  nmlist=[]
  typlist=[]
  paramlist=[]
  #print term, p_field, convert
  for fi, pi in zip(ti[0], ti[1]):
   if verbose: print i, fi
   typetuple = top.gettypetuple(fi)
   #print typetuple
   if pi==[]:
    plist= g_param.get_parameter_entry(typetuple, term)
    if term=='NBFIX': #this is specific for charmm format
     plist = [ii[2:] for ii in plist]
   else:
    plist= [readFF.converParam([float(ii) for ii in pi], p_field, convert)]
   nmlist.append(fi[:])
   typlist.append(typetuple[:])
   paramlist.append(plist)

 #for nm, typ, param in zip(nmlist, typlist, paramlist):
 # print term, nm, typ, param
  topparam.append([nmlist, typlist, paramlist])
  topterm.append(term)

 return dict([(i,j) for i,j in zip(topterm, topparam)])




class Top2Param:
#public
#load_rule  loading rules for corresponding FF format
#all rules should be avai in module top_db
 def __init__(self, ff, load_rule):
  self.__ff = ff
  self.__load_rule = load_rule(ff)

 def all_rule_term(self):
  return self.__load_rule.keys()
 #return list of parameters for typeTuple
 def get_parameter_entry(self, typeTuple, term):
  
  clr = self.__load_rule[term]
  typlist = clr[0] #for detail, look at the rules in top_db.py
  paramlist = clr[2] #assuming rules as {term:[typ, typ_len, param,...]}
  ff_idx_list = readFF.match_FF_list(typeTuple, typlist)  
  #check if 'X' in list, this is specific for charmm
  idx_list_noX=[]
  idx_list_X=[]
  for i in ff_idx_list:
   if 'X' in typlist[i]: 
    idx_list_X.append(i)
   else:
    idx_list_noX.append(i)

  if idx_list_noX!=[]:
   re= idx_list_noX
  else:
   re= idx_list_X

  if re==[]: 
   print 'No',term,'parameters could be found for',typeTuple
   sys.exit()
  
  return [paramlist[i][:] for i in re]

 #def get_parameter_list (self, typelist, term):
  

