import sys
from out_put import *
from PDB import *
from geom import *
#from out_put import *
import top_db
from helper import *
#===FUNC=====

def is_coord_out_box (xp_t, box,padding):
 for dim in range(3):
  if xp_t[dim]<-0.5*box[dim]-padding: return True
  if xp_t[dim]>0.5*box[dim]+padding: return True
 return False


def is_out_box (xp_t, box,padding=-0.1):
 for x in xp_t:
  if is_coord_out_box(x,box,padding): return True
 return False

def is_clash (xp_t, xp, box_cell, clash_cut):
 for x in xp_t:
  contact_list = box_cell.contact(x,xp, clash_cut)
  if len(contact_list)>0: return True
 return False

#This program combines multiple PDB into one
#remove exclutions as an option
#require each PDB has been processed: correct atom, res and seg names
#for psfgen
#====Main==========
if 'Readtext' in sys.argv:
 idx=sys.argv.index('Readtext')
 arg = file_2_arg(sys.argv[idx+1])
else:
 arg=sys.argv

if len(arg)<3: 
 print 'Nothing to combine'
 quit()

pdb_file=[]
for i in arg:
 if i[-4:]=='.pdb':
  pdb_file.append(i)

rtf_file=''
for i in range(1,len(arg)):
 if arg[i][-3:] in ['rtf','str','inp']:
  rtf_file+=arg[i]+' '

if len(pdb_file)<2:
 print 'Need more pdb files'
 quit()

syss=[]
for i in pdb_file:
 print 'Loading ',i
 syss.append(PDBdata(i))

zexclu=False
if 'Z-exclusion' in arg:
 zexclu=True
 idx=arg.index('Z-exclusion')
 zres='SOL'
 zl=-15.
 zu=15.
 if idx<len(arg)-1:
  zres=arg[idx+1]
  zl=float(arg[idx+2])
  zu=float(arg[idx+3])
 print 'all residue',zres,'between',zl,'and',zu,'in Z coordinate will be excluded'

exclu=False
if 'exclusion' in arg:
 print 'Exclusion Mode is on'
 exclu=True
 cut2 = []
 idx=arg.index('exclusion')
 if idx<len(arg)-1:
  for i in range(idx+1,idx+len(pdb_file)):
   c2= float(arg[i])
   cut2.append(c2*c2)
 else:
  for i in range(len(pdb_file)-1):
   cut2.append(4.*4.)


 if not 'box' in arg:
  print 'Err! box size needs to be specified while using exclusion'
  quit()
 idx=arg.index('box')
 box=[]
 for i in range(1,4):
  box.append(float(arg[idx+i]))
 print 'Size of box is',box

#start combining=============
all_sys=PDBdata()
aid=0
#load first pdb
for i in syss[0].atoms:
 aid+=1
 i[0]=aid
 all_sys.atoms.append(i)
all_sys.build_struct()

#build link cell if exclusion is on
#the MC of the whole system should be at origin
if exclu:
 box_cell = link_cell(box, 10.)
 


for j in range(1,len(syss)):
 clash_cut = cut2[j-1]
 #print clash_cut
 cur_sys = syss[j]
 if exclu:
  box_cell.clear_atoms 
  box_cell.load_atoms(all_sys.xp)
 reslist_cur=cur_sys.reslist
 
 for i in reslist_cur:
  ok=True
  if zexclu:
   if i[2]==zres:
    zc=cur_sys.xp[i[0]][2]
    if zc>zl and zc<zu: ok=False
  if exclu:
   xp_t=[]
   for j in range(i[0],i[0]+i[1]):
    xp_t.append(cur_sys.xp[j])
   if is_out_box (xp_t, box): ok=False
   if ok:
    if is_clash (xp_t, all_sys.xp, box_cell, clash_cut): ok=False
  if not ok:
   #print cur_sys.atoms[i[0]][8]+':'+i[2]+str(cur_sys.atoms[i[0]][4]),
   continue
  for j in range(i[0],i[0]+i[1]):
   aid+=1
   cur_sys.atoms[j][0]=aid
   all_sys.atoms.append(cur_sys.atoms[j])
 all_sys.build_struct()
print
#now all_sys has all stuff
#looking for DISU
cys_S_list = gen_cys_s_list(all_sys)
disu_list =check_disu (all_sys, cys_S_list)

#output
output_build_tcl(rm_directory(pdb_file[0][:-4]), rtf_file,\
                 all_sys, disu_list,'combined structures','_combined');
output_build_pdb(rm_directory(pdb_file[0][:-4]), all_sys)

