import sys
from PDB import *
import top_db

def fw_mlines(f, l_list):
 for i in l_list:
  f.write(i+'\n')

def print_f(f,l=''):
 if f is None:
  print l
 else:
  f.write(l+'\n')

def output_build_tcl(fnm,top_file, system, disu_list,part='proteins',suf='_auto'):
 print_title('Please note:')
 print fnm+suf+'.tcl has been generated.'
 print 'Try to use psfgen to generate psf with this tcl file.'
 print 'You should get ',fnm+suf+'.pdb and',fnm+suf+'.psf for',part
 f=open(fnm+suf+'.tcl','w')
 fw_mlines(f,['package require psfgen'])
 pro_res = top_db.pro_res_nm_db()

 srl=top_file.split()
 for i in srl:
  fw_mlines(f,['topology '+i])


 c_list = system.get_segments(False)
 for ik in range(len(c_list)):
  i =c_list[ik]
  if i>=len(system.atoms): continue
  resnm_list=[]
  is_pro=False
  for ii in range(i,c_list[ik+1]):
   if system.atoms[ii][2] in pro_res: is_pro =True
   if not system.atoms[ii][2] in resnm_list:
    resnm_list.append(system.atoms[ii][2])

  segnm = system.atoms[i][8]
  pdb_file = fnm+'-'+segnm+'.pdb'
  if not is_pro:
   auton='auto none\n'
  else:
   auton=''
  fw_mlines(f,['segment '+segnm+' {\n'+auton+'pdb '+pdb_file+'\n}'])
  if 'ILE' in resnm_list:
   fw_mlines(f,['pdbalias atom ILE CD1 CD'])
              
  fw_mlines(f,['coordpdb '+pdb_file+' '+segnm])

 for i in disu_list:
  fw_mlines(f,['patch DISU '+i[0]+' '+i[1]]) 

 fw_mlines(f,['guesscoord',\
        'writepdb '+fnm+suf+'.pdb',\
        'writepsf '+fnm+suf+'.psf',\
        'exit'])

 f.close()


def output_build_pdb(fnm, system):
 c_list = system.get_segments(False)
 for j in range(len(c_list)-1):
  st =c_list[j]
  en =c_list[j+1]
  #print st, en
  segnm = system.atoms[st][8]
  pdb_file = fnm+'-'+segnm+'.pdb'
  f=open(pdb_file,'w')
  for i in range(st, en):
   fw_mlines(f,[pdb_atom_string(system.atoms[i])])
  fw_mlines(f,['END'])
  f.close()

def rm_directory(fnm):
 i = len(fnm)-1
 pos=-1
 while i>=0:
  if fnm[i]=='/':
   pos = i
   break
  i-=1
 if pos<0: return fnm
 return fnm[pos+1:]
 
def print_title(title):
 upline='+'
 for i in range(len(title)): upline+='-'
 upline+='+'
 print upline
 print '|'+title+'|'
 print upline
