import math
import sys

def dist(x,y):
 d=x[0]-y[0]
 d2=d*d
 d=x[1]-y[1]
 d2+=d*d
 d=x[2]-y[2]
 d2+=d*d
 return d2**0.5

def dist2(x,y):
 d=x[0]-y[0]
 d2=d*d
 d=x[1]-y[1]
 d2+=d*d
 d=x[2]-y[2]
 d2+=d*d
 return d2

def draw_line(x,y,mol=0):
    print "graphics %d cylinder {"%mol+\
    "{0:.2f} {1:.2f} {2:.2f}".format\
    (x[0],x[1], x[2])+\
    "} {"+ "{0:.2f} {1:.2f} {2:.2f}"\
    .format(y[0],y[1],y[2])+"} radius 0.5 resolution 20 filled yes"


def calxyz( c1, c2, c3,  b,  a,  d):
    ci=[0.,0.,0.]
    r=[0.,0.,0.]
    h=[0.,0.,0.]
    r21=[0.,0.,0.]
    r23=[0.,0.,0.]
    rb=[0.,0.,0.]
    rb21=[0.,0.,0.]
    rc=[0.,0.,0.]
   


  
    PI=3.141592654
    ca=a;
    cb=b;
    cd=d;
    ca=ca/180.*PI;
    cd=cd/180.*PI;
             
    VECSUB(r21, c1, c2);
    VECSUB(r23, c3, c2);
             
    VECOUT(r, r21, r23);

    VECOUT(h, r21, r);

             

    rv=VECLEN(r);
    hv=VECLEN(h);
    r21v=VECLEN(r21);


    VECELONG(r,r,1./rv);
             
    VECELONG(h,h,1./hv);

    VECELONG(r21,r21,1./r21v);


    rbv=cb*math.sin(ca);

    VECELONG(rb21, r21, math.cos(PI-ca)*cb); 
             
    VECELONG(rc, h, math.cos(PI-math.fabs(cd)) );
    VECELONG(rb, r, math.sin(math.fabs(cd))*_fsgn(cd) );
    VECADD (rb, rb, rc);
    VECELONG (rb, rb, rbv);


    VECADD( ci, rb, rb21);
    VECADD( ci, ci, c1);

    return ci        


def bond(ci, c1):


 r14=[0.0,0.0,0.0]
   
 VECSUB(r14,ci,c1)
   
 return VECLEN(r14)


def angle(ci,c1,c2):

   r14=[0.0,0.0,0.0]
   r21=[0.0,0.0,0.0]
   

   VECSUB(r14,ci,c1);
   r14v=VECLEN(r14);

   VECSUB(r21,c1,c2);
   r21v=VECLEN(r21);
      
   cs=VECDOT(r14,r21)/r14v/r21v;


    
   ca=math.atan(math.sqrt(1-cs*cs)/math.fabs(cs));
   PI=3.141592654
   if cs>0.0: ca=PI-ca
   return ca/PI*180

def dihedral(ci,c1,c2,c3):


    r=[0.0,0.0,0.0]
    r14=[0.0,0.0,0.0]
    r21=[0.0,0.0,0.0]
    r23=[0.0,0.0,0.0]
    ra=[0.0,0.0,0.0]
    rb=[0.0,0.0,0.0]
    rc=[0.0,0.0,0.0]
    rd=[0.0,0.0,0.0]
    

     
    VECSUB(r14, ci,c1)
  
     


    VECSUB(r21,c1,c2)
      

    r21v=VECLEN(r21)

    VECSUB(r23,c3,c2)
      
    VECOUT(r,r21,r23)

       

    cs=VECDOT(r21,r14)/r21v/r21v
    VECELONG(ra,r21,cs)

      
     
      

    cs=VECDOT(r21,r23)/r21v/r21v
    VECELONG(rc,r21,cs)

    VECSUB(rb,r14,ra)

    VECSUB(rd,r23,rc)
       
    rdv=VECLEN(rd)
    rbv=VECLEN(rb)

       

    cs=VECDOT(rb,rd)/rdv/rbv



    cd=math.atan(math.sqrt(math.fabs(1-cs*cs))/math.fabs(cs));

    PI=3.141592654
    if cs<0: cd=PI-cd
    cd*=_fsgn(VECDOT(r14,r))
    return cd/PI*180

#add a new H atom to ci if c1 c2 c3
#connecting to ci
def add1H_pyra(ci, c1, c2, c3):


  ci1=[0.,0.,0.]
  ci2=[0.,0.,0.]
  ci3=[0.,0.,0.]
  hyg=[0.,0.,0.]

  VECSUB(ci1,c1,ci)
  VECSUB(ci2,c2,ci)
  VECSUB(ci3,c3,ci)
  c1v=VECLEN(ci1)
  c2v=VECLEN(ci2)
  c3v=VECLEN(ci3)

  VECELONG(ci1,ci1,1.0/c1v)
  VECELONG(ci2,ci2, 1.0/c2v)
  VECELONG(ci3,ci3, 1.0/c3v)

  VECADD(ci1,ci1,ci2)
  VECADD(ci1,ci1,ci3)
  c1v=VECLEN(ci1)
  VECELONG (ci1,ci1,1.0/c1v)
  VECSUB(hyg,ci,ci1)


  return hyg






def _fsgn(a):
 if a>0: return 1
 if a<0: return -1
 return 0
  
def VECADD(c,a,b):
 c[0]=a[0]+b[0]
 c[1]=a[1]+b[1]
 c[2]=a[2]+b[2]

def VECSUB(c,a,b):
 c[0]=a[0]-b[0]
 c[1]=a[1]-b[1]
 c[2]=a[2]-b[2]

def VECLEN(a):     
 return (a[0]*a[0]+a[1]*a[1]+a[2]*a[2])**0.5

#define VECDOT(a,b)   ((a)[XX]*(b)[XX]+(a)[YY]*(b)[YY]+(a)[ZZ]*(b)[ZZ])

def VECDOT(a,b):
 return a[0]*b[0]+a[1]*b[1]+a[2]*b[2]

def VECOUT(c,a,b):
  c[0]=a[1]*b[2]-a[2]*b[1]
  c[1]=a[2]*b[0]-a[0]*b[2]
  c[2]=a[0]*b[1]-a[1]*b[0]

def VECELONG(c,a,v):
  c[0]=a[0]*(v)
  c[1]=a[1]*(v)
  c[2]=a[2]*(v)

#define PRVEC(a)     printf("%f %f %f\n", (&a)[XX], (&a)[YY], (&a)[ZZ])
#define VECCPY(c,a)    (c)[XX]=(a)[XX];(c)[YY]=(a)[YY];(c)[ZZ]=(a)[ZZ]
#define ZMAX_DIH(a,b)  ((a)==NULL?(b):( (*(a))+(b) ))      

      
def find_max_min(xp):
 n=len(xp)
 minb=[0.,0.,0.]
 maxb=[0.,0.,0.]
 first=True
 for x in xp:
  if first:
   first=False
   for dim,xi in enumerate(x):
    minb[dim]=xi
    maxb[dim]=xi
  else:
   for dim, xi in enumerate(x):
    if minb[dim]>xi: minb[dim]=xi
    if maxb[dim]<xi: maxb[dim]=xi
 return maxb, minb


def make_large_sbox(sbox, sbox_size, sbox_rep, pf='S'):
 na=[]
 reslist = sbox.reslist
 segid=1
 resid=1
 atoms=sbox.atoms
 for ix in range(sbox_rep[0]):
  for iy in range(sbox_rep[1]):
   for iz in range(sbox_rep[2]):
    bx = ix * sbox_size[0]
    by = iy *sbox_size[1]
    bz = iz * sbox_size[2]
    for i in reslist:
     for j in range(i[0],i[0]+i[1]):
      na.append([99999, atoms[j][1], atoms[j][2], atoms[j][3], resid,\
                 atoms[j][5]+bx, atoms[j][6]+by, atoms[j][7]+bz,
                 pf+str(segid)])
     resid+=1
     if resid>999:
      resid=1
      segid+=1
 return na

class link_cell:
 def __init__(self, box, cut):
  self.box_size=[]
  self.cell_dim=[]
  self.cell_size=[]
  for i in box:
   dim=int(i/cut)
   self.box_size.append(i)
   self.cell_dim.append(dim)
   self.cell_size.append(i/float(dim))
  
  self.cell_link=[]
  self.cell_list=[]
  for xi in range(self.cell_dim[0]):
   for yi in range(self.cell_dim[1]):
    for zi in range(self.cell_dim[2]):
     self.cell_list.append([])
     self.cell_link.append(make_cell_link(xi, yi, zi, self.cell_dim))
    
 def load_atoms(self,xp):
  c_s=self.cell_size
  b_s=self.box_size
  for i,x in enumerate(xp):
   xi = int((x[0]+0.5*b_s[0])/c_s[0])
   yi = int((x[1]+0.5*b_s[1])/c_s[1])
   zi = int((x[2]+0.5*b_s[2])/c_s[2])
   
   c_id = xyz2c_id(xi,yi,zi, self.cell_dim)
   #print x, xi, yi, zi, c_id
   self.cell_list[c_id].append(i)

 def clear_atoms(self):
  for i in self.cell_list:
   i=[]

 def contact(self, x, xp, clash_cut2):
  re=[]
  c_s=self.cell_size
  b_s=self.box_size
  xi = int((x[0]+0.5*b_s[0])/c_s[0])
  yi = int((x[1]+0.5*b_s[1])/c_s[1])
  zi = int((x[2]+0.5*b_s[2])/c_s[2])
  c_id = xyz2c_id(xi,yi,zi, self.cell_dim)
  c_list= self.cell_list[c_id]

  for idx in c_list:
   x_r = xp[idx]
   d2= dist2(x, x_r)
   if d2<clash_cut2:
    re.append([idx, d2])

  return re  

def xyz2c_id(x,y,z, cell_dim):
 cell_dx=cell_dim[0]
 cell_dy=cell_dim[1]
 cell_dz=cell_dim[2]
 if x>= cell_dx: x-=cell_dx
 if x<0: x+=cell_dx
 if y>= cell_dy: y-=cell_dy
 if y<0: y+=cell_dy
 if z>= cell_dz: z-=cell_dz
 if z<0: z+=cell_dz

 #print x,y,z
 return x*cell_dy*cell_dz+\
        y*cell_dz + z


def make_cell_link(xi, yi, zi, cell_dim):
 t_list=[]
 t_list.append(xyz2c_id(xi,yi,zi, cell_dim))
 for i in [-1,0,1]:
  for j in [-1,0,1]:
   for k in [-1,0,1]:
    if i==0 and j==0 and k==0: continue
    c_id= xyz2c_id(xi+i,yi+j, zi+k, cell_dim)
    t_list.append(c_id)
 return t_list


def centroid(xp_list):
 re=[0.,0.,0.]
 for i in xp_list:
  VECADD(re,re,i)
 VECELONG(re,re,1./float(len(xp_list)))
 return re


#make whole of polymer by fixpoint th atom
def makewhole(xp, fixpoint, box):
 if fixpoint >= len(xp) or fixpoint<0:
  print 'wrong idx'
  sys.exit()

 for i in range(fixpoint+1, len(xp)):
  pbc_move(xp[i], xp[i-1], box)


 for i in range(fixpoint-1, -1, -1):
  pbc_move(xp[i], xp[i+1], box)


#mov x close to ref according to box
def pbc_move(x, ref, box):
 for i in range(3):
  if x[i]-ref[i]>0.5*box[i]:
   x[i]-=box[i]
   
  if x[i]-ref[i]<-0.5*box[i]:
   x[i]+=box[i]

#convert coeff in RB dih to fourier seires
def ur2dihe(c):
 k=[]
 k.append(-c[1]-5./8.*c[5]-3./4.*c[3])
 k.append(0.5*(c[2]+c[4]))
 k.append(-5./16.*c[5]-c[3]/4.)
 k.append(c[4]/8.)
 k.append(-c[5]/16.)
 return k

#convert c6 c12 to emin rmin

def Coff2EminRmin(C6, C12):
 if C12==0.0 or C6==0.0: return (0.0,0.0)
 epsilon = C6*C6/C12/4.
 rmin = (2.*C12/C6)**(1/6.)
 return (epsilon, rmin)

def EminRmin2Coff(emin, rmin):
 return (2.*emin*(rmin**6), emin*(rmin**12))

def Ecos(phi, param):
 return param[0]*(1.+math.cos((param[1]*phi-param[2])/180.*3.141592654)) 
