#!/usr/bin/python
import sys
sys.path.append('/Users/weihan/pyscript')


from helper import *
from connectivity import *
from PDB import *
from readFF import *
from readTop import *
from atomtyping import *
import top_db
import TwoD_data
import out_put

#main
#load info from gaussian and antechamber
opt=[]
for i in range(1, len(sys.argv)): opt.append(sys.argv[i])

if opt==[]:
 print 'Option	Remark'
 print '-pdb	pdb files with crystal coordinates'
 print '-ff	amber force field file'
 print '-gau	Gaussian log file with optimized structures'
 print '-top	rtf file with amber topology'
 print '-chr	Gaussian output for ESP'
 
 sys.exit()
pdbfile= arg_w_opt(opt,'-pdb')
fffile= arg_w_opt(opt,'-ff')
antefile = arg_w_opt(opt,'-gau')
topfile= arg_w_opt(opt,'-top')
chargefile= arg_w_opt(opt,'-chr')
isgmx= arg_w_opt(opt,'-gmx','no')

#antefile=sys.argv[1]
#fffile=sys.argv[3]
#topfile=sys.argv[2]
#chargefile=sys.argv[4]
#resname=sys.argv[6]
#pdbfile=sys.argv[5]


print 'loading PDB coordinate from',pdbfile
pdb= PDBdata(pdbfile)
resname= pdb.atoms[0][2]
print 'There are ',len(pdb.atoms),'atoms in this pdb'
k=0
for i in pdb.atoms:
 if i[1][0]!='H': k+=1
print k,'heavy atoms found'

print 'loading connectivity file...',antefile
mol = PDBdata(antefile, True)
conn = connect(None, False, None, mol)
#print conn.c12
#print conn.c13
#print conn.c14
#conn.gen_impr_list(mol.atomnms,True)
#print conn.impr
#sys.exit()

atoms=mol.atoms
print 'There are ',len(atoms),'atoms among which ',
k=0
for i in atoms: 
 if i[1][0]!='H': k+=1
print k,'heavy atoms found'

print 'loading force field file', fffile
FF = FFdata(fffile)
print 'loading topology file', topfile
atyp = load_atom_type(topfile)
print len(atyp),'types found in topology file'

#===========
#load charge for each atom
print 'loading guassian charge from ',chargefile
charge= ChargeGaussian(chargefile)
print len(charge),'atomic charge found'

print 'New residue name will be', resname
#for i,j in zip(mol.atomnms, charge): print i,j
#FF.show('test')
#for i in atyp: print i

#change name
n_cnt={'C':0,'N':0,'O':0,'P':0,'S':0,'H':0}
for i in range(len(atoms)):
 a=atoms[i][1]
 n_cnt[a[0]]+=1
 atoms[i][1]=a[0]+'_'+str(n_cnt[a[0]])
mol.build_atomnms()
#change name in pdb file
n_cnt={'C':0,'N':0,'O':0,'P':0,'S':0,'H':0}
for i in range(len(pdb.atoms)):
 a=pdb.atoms[i][1]
 n_cnt[a[0]]+=1
 pdb.atoms[i][1]=a[0]+'_'+str(n_cnt[a[0]])
pdb.build_atomnms()

#pdb.show_pdb()
#mol.show_pdb()
#sys.exit()
#i=0
#for j in mol.atomnms:
# if j[0]!='H':
#  print j, pdb.atomnms[i]
#  i+=1

#print match_list(['A','B','C','D'],['X','X','C','Y'])
#temperary typ
#mapping to original force field, but they will have diff
#bond and charge params except for vdW
newtypmapping=[]
t_typ= guess_atomtype (mol.atomnms, conn.get_direct_conn(),\
   top_db.amber_atom_type_rule() ,atyp, newtypmapping)

#xp_pdb = pdb.xp
#xp_qm = mol.xp  
#nm_pdb = pdb.atomnms
#nm_qm = mol.atomnms 

correct_Hpositive_amber(t_typ, conn.get_direct_conn())

print 'Determined types:'
show_assigned(mol.atomnms, [1 for i in range(len(mol.atoms))],\
t_typ, get_hybrid_state(mol.atomnms, conn.get_direct_conn()))
#assign parameters to new types if they can be tranfered from
#know types or provided coordinates

if len(newtypmapping)>0:
                #FF    pdb geo QM geo QM conn  assinged types   newtypes  atomtypes
 assign_param_newtyp(FF, pdb, mol,conn,t_typ, newtypmapping, atyp)
       #after this FF should be ready to have enough info for new types

  
#generate improper
conn.gen_impr_list(mol.atomnms,True)

mis=1

while mis>0:
 cim_set2FF=[ match_impr_amber_list(i, FF.imprs, t_typ)   for i in conn.impr]
#bonded term bond angle, force constant from FF, 
#eq value from QM
#dih and improper all from FF
 c12_typ = [get_nb_nm_list(i, conn.c12, t_typ) for i in range(len(conn.c12))]
 c13_typ = [get_nb_nm_list(i, conn.c13, t_typ) for i in range(len(conn.c13))]
 c14_typ = [get_nb_nm_list(i, conn.c14, t_typ) for i in range(len(conn.c14))]
 cim_typ = [get_nb_nm_list(i, conn.impr, t_typ) for i in range(len(conn.impr))]
#nm used for new type
 c12_nm = [get_nb_nm_list(i, conn.c12, mol.atomnms) for i in range(len(conn.c12))]
 c13_nm = [get_nb_nm_list(i, conn.c13, mol.atomnms) for i in range(len(conn.c13))]
 c14_nm = [get_nb_nm_list(i, conn.c14, mol.atomnms) for i in range(len(conn.c14))]
 cim_nm = [get_nb_nm_list(i, conn.impr, mol.atomnms) for i in range(len(conn.impr))]

#print cim_typ
#sort_reverse_list(c12_typ)
#sort_reverse_list(c13_typ)
#sort_reverse_list(c14_typ)

#c12_set=TwoD_data.unq_set(c12_typ)
#c13_set=TwoD_data.unq_set(c13_typ)
#c14_set=TwoD_data.unq_set(c14_typ)

#now show if bond could be found
 c12_set2FF=[ match_FF_list(i, FF.bonds)   for i in c12_typ]
 c13_set2FF=[ match_FF_list(i, FF.angles)   for i in c13_typ]
 c14_set2FF=[ match_FF_list(i, FF.dihes)   for i in c14_typ] 
#sys.exit()
#here interactive input parameters
 mis=0
 mis+=show_missing(c12_set2FF, c12_typ, c12_nm,'BOND',atyp)
 mis+=show_missing(c13_set2FF, c13_typ, c13_nm,'ANGLE',atyp)
 mis+=show_missing(c14_set2FF, c14_typ, c14_nm,'DIHEDRAL',atyp)
 mis+=show_missing(cim_set2FF, cim_typ, cim_nm,'IMPROPER',atyp)
 if mis>0:
  input_param(FF, atyp)
# break

#we have all the parameters
#simple version : no new type generated
ntop= ResTop() #empty topology
#crowl molecule by connectivity
crl_order= crowl_molecule(conn.get_direct_conn(), mol.atomnms)
#crl_order=[i for i in range(len(mol.atoms))]
#print len(mol.atomnms)
#print len(crl_order)
#for i in crl_order:
# print mol.atomnms[i], t_typ[i] 
xp_list=[]
for i in crl_order:
 xp_list.append(mol.xp[i])
 ntop.atomnms.append(mol.atomnms[i])
 ntop.atoms.append([t_typ[i], charge[i]])
ntop.atom_attr = dict([(x,y) for x,y in zip(ntop.atomnms, ntop.atoms)])
for i in c12_nm:
 ntop.bonds.append(i)
for i in cim_nm:
 ntop.imprs.append(i)
ntop.resnm=resname
#internal coordinate
ntop.make_IC(xp_list)
print 'Checking integrity of pdb structure...'
mol.integrity_check()
print 'Checking integrity of topology....'
ntop.integrity_check()


cnn_t=connect(None, True, ntop)
cnnt=cnn_t.get_direct_conn()

#for i,j in zip(mol.conn, cnnt): 
# if i!=j:
#  print i,j
#ntop.integrity_check()
#print 'Topology output to:', topfile[:-4]+'_%s.rtf'%(resname)
out_put.print_title('This is topology for simulation')
for j,i in enumerate(atyp):
 print 'MASS',j+1, i[0], '%.5f'%(i[1]),i[2]
print
print 'AUTO ANGLES DIHE'
print
ntop.show()

#prepare pdb with new name:
print_title('Other important files')
print 'Output new pdb:', pdbfile[:-4]+'_%s.pdb'%(resname)
pdb.show_pdb(pdbfile[:-4]+'_%s.pdb'%(resname),['H'])
print 'Output new FF file:', fffile[:-4]+'_%s.prm'%(resname)
FF.show('adding %s'%(resname), fffile[:-4]+'_%s.prm'%(resname))



