#reading xyz for top atoms
#top and obj must have attributes of atomSig and unq and atomnms and conn
#obj should have a method to load cord for any atom it has
#obj must include top
#make sure both top and obj have passed integrity check
from readTop import ResTop
from PDB import PDBdata
import sys

#compair sig
#assuming a shorter than b
def _sigcmp(sigi, sigj):
 for k in range(len(sigi)):
  if k%3==2: continue
  if sigi[k]<sigj[k]: return -1
  if sigi[k]>sigj[k]: return 1
 return 0

#find index of Sigs match sigi
#assuming Sigi has less eles than sigs[i]
def findMatch(Sigi, Sigs):
 l,r=(0, len(Sigs)-1)
 #binary search
 while (l<=r):
  m=int((l+r)/2)
  scmp= _sigcmp(Sigi, Sigs[m])
  if scmp==0: return m
  if scmp<0: r=m-1
  if scmp>0: l=m+1
 return -1

#return a list of obj atoms wichi match atom i in top
def possibleMatch(top, obj, i, markobj):
 list_match=[]
 idx_j = findMatch(top.atomSigs[i], obj.atomSigs)
 if (idx_j)<0:
  print 'Err! atom',i,'in top has no counterpart in obj.'
  quit()
 ref=obj.unq[idx_j][0]
 for i in range(ref, ref+obj.unq[ref][1]):
  if markobj[i]==0:
   list_match.append(i)
 if (len(list_match)==0):
  print 'Err! atom',i,'has no available counterpart in obj'
  quit()
 return list_match
#return a list of indices which correspond to 
#a group of atoms that have least degeneracy
def findUnq (obj,countobj, markobj):
 list_obj=[]
 i=0
 mini= len(obj.unq)
 mini_i=-1
 while i<len(obj.unq): 
  if countobj[i]<mini:
   mini=countobj[i]
   mini_i = i
  step=obj.unq[i][1]
  i+=step
 if mini_i=-1:
  print 'Err! findUnq doesnot find anything'
  quit()
 for i in range(mini_i, mini_i+obj.unq[mini_i][1]):
  if markobj[i]==0:
   list_obj.append(i)
 return list_obj

#return i,j tuple according to user chosen pair of i,j's
#return -1, -1 if nothing found
def pick_pair(top, obj, list_top, markobj):
 opt=[]
 for i in list_top:
  list_obj = possibleMatch(top, obj, i, markobj)
  for j in list_obj:
   opt.append((i,j))
 if len(opt)==0:
  return -1, -1 
 choice=0
 if len(opt)>1:
  print 'Following matches are possible:'
  for k,i in enumerate(opt):
   x,y=i
   idx_x, idx_y = (top.atomSigs[x][2], obj.atomSigs[y][2])
   print  k,':',top.atomnms[idx_x],'<==',obj.atomnms[idx_y]
  
  choice=-1
  while choice<0 or choice>=len(opt)
   print 'Please choose one [ 0-',len(opt)-1,']'
   s=sys.stdin.readline()
   choice=int(s[:-1])
 x,y=opt[choice]
 print 'Following pair is chosen:'
 idx_x, idx_y = (top.atomSigs[x][2], obj.atomSigs[y][2])
 print  k,':',top.atomnms[idx_x],'<==',obj.atomnms[idx_y]
 
 return opt[choice]

#return a tuple of indice i and j
#i ele in top matches j ele in obj
def set_init_match(top,obj, cnttop,  marktop, markobj):
 list_top = findUnq(top,cnttop, marktop) 
 return pick_pair(top, obj, list_top, markobj)
#============
def mark_idx(j_ini, obj, cntobj, markobj):
 unq=obj.unq
 ref=unq[j_ini][0]
 cntobj[ref]-=1
 markobj[j_ini]=1
#=====================
def xyz4top (top, obj):
 topSig=top.atomSigs
 objSig=obj.atomSigs
 if len(topSig)>len(objSig):
  print 'Err! The topology has more atoms than provided coordinates.'
  print 'Please use maskoff option to construct atom signatures.'
  return
 marktop=[0 for i in range(len(topSig))]
 markobj=[0 for i in range(len(objSig))]
 cnttop=[i[1] for i in top.unq]
 cntobj=[i[1] for i in obj.unq]
 n = len(topSig) 
#find uniq sigs
 i_ini, j_ini = set_init_match(top, obj, cnttop, marktop, markobj)
 if i_ini<0 or j_ini<0:
  print 'Err! cannot find any pair of matching atoms.'
  quit()
 mark_idx(i_ini, top, cnttop, marktop)
 mark_idx(j_ini, obj, cntobj, markobj)
 n-=1
 while (n>0):
  return
  
