#import numpy
import sys
import math

def unq_set(X,tosort=True):
 u_x=[]
 for i in X:
  if not i in u_x:
   u_x.append(i)
 if tosort: u_x.sort()
 return u_x

class Data_XYZ:

 def __init__(self, fnm):
  f=open(fnm,'r')
  self.X=[]
  self.Y=[]
  self.Z=[]
  for rl in f:
   srl=rl[:-1].split()
   if len(srl)==0: continue
   if '#' in srl[0] or '@' in srl[0]: continue
   self.X.append(float(srl[0]))
   self.Y.append(float(srl[1]))
   self.Z.append(float(srl[2]))
  f.close()
  X, Y, Z=(self.X, self.Y, self.Z)

  self.xmin = min(X)
  self.xmax= max(X)
  self.ymin = min(Y)
  self.ymax = max(Y)
  self.zmin = min(Z)
  self.zmax = min(Z)

 def log_scale(self,mincut):
  Z=self.Z
  for i in range(len(Z)):
   if Z[i]<mincut:
    Z[i]=mincut
   Z[i]=math.log(Z[i])-math.log(mincut)
  
  
#return X, Y, Z for 2D contour plot

 def for2Dplot(self):
  unq_x = unq_set(self.X)
  unq_y = unq_set(self.Y)
  nx = len(unq_x)
  ny = len(unq_y)
  x = numpy.array(unq_x)
  y = numpy.array(unq_y)
  X, Y = numpy.meshgrid(x, y)  
  Z = numpy.zeros((ny, nx))
  #fill out z
  for ix, iy, iz in zip(self.X, self.Y, self.Z):
   idx_x = unq_x.index(ix)
   idx_y = unq_y.index(iy)
   Z[idx_y][idx_x] = iz
  return X, Y, Z
  
class Data_XY:

 def __init__(self, fnm):
  f=open(fnm,'r')
  self.X=[]
  self.Y=[]
  cnt=0
  for rl in f:
   srl=rl[:-1].split()
   if len(srl)==0: continue
   if '#' in srl[0] or '@' in srl[0]: continue

   self.X.append(float(srl[0]))
   for j in range(1,len(srl)):
    if cnt==0:
     self.Y.append([])
    self.Y[j-1].append(float(srl[j]))
   cnt+=1 
   
  f.close()
  X, Y=(self.X, self.Y)

  self.xmin = min(X)
  self.xmax= max(X)
  min_all= [min(i) for i in Y]
  max_all= [min(i) for i in Y]
  self.ymin = min(min_all)
  self.ymax = max(max_all)

 def for1Dplot(self):
  x= numpy.array(self.X)
  y=[]
  for i in self.Y:
   y.append(numpy.array(i))
  return x,y
