# vmd -dispdev text <psf> <dcd> -e trj.tcl -args <image no.> <swarm index>

set psffile [lindex $argv 0]
set image [lindex $argv 1]
set swarmnum [lindex $argv 2]
mol new $psffile
mol addfile before_swarm_$image.pdb type pdb waitfor all molid 0

set fitstring "OL NL CLP CL"
set targstring "CB CA OR NR"


for {set i 1} {$i <= $swarmnum} {incr i} {
	mol addfile ./run_swarm/swarm_$image.$i.dcd type dcd waitfor all molid 0
	set reference [atomselect 0 "not water and name $fitstring" frame 0]
	set compare [atomselect 0 "not water and name $fitstring" frame $i]
	set mat [measure fit $compare $reference weight mass]
	set comparepro [atomselect 0 "not water and not ion" frame $i]
	$comparepro move $mat
}

set averagepos [atomselect 0 "not water and name $targstring"]
set posi [measure avpos $averagepos first 1 last $swarmnum step 1]

set newframe [expr $swarmnum + 1 ]
mol addfile before_swarm_$image.pdb type pdb waitfor all molid 0
set add_pos [atomselect 0 "not water and name $targstring" frame $newframe]
$add_pos set {x y z} $posi
set small_rmsd 10
set small_image -1
for {set i 1} {$i <= $swarmnum} {incr i} {
	set now_pos [atomselect 0 "not water and name $targstring" frame $i]
	set now_rmsd [measure rmsd $add_pos $now_pos]
	if {$now_rmsd < $small_rmsd} {
		set small_rmsd $now_rmsd
		set small_image $i
		}
}
puts "$small_image"	
set writepro [atomselect 0 "not water and not ion" frame $small_image]
#$add_pos writepdb "ave_real.$image.pdb"
$writepro writepdb "ave.$image.pdb"
exit

