
proc getsimplecoor { fileName } {
set inStream [open $fileName "r"]    
set i 0
set coords {}
foreach line [split [read $inStream] \n] {  
set posiList [regexp -inline -all -- {\S+} $line] 
set posi [split $posiList " "]
set x [lindex $posi 0]
set y [lindex $posi 1]
set z [lindex $posi 2]
if {[string is double -strict $x] && [string is double -strict $y] \
&& [string is double -strict $z]} {
lappend coords [concat $x $y $z] 
incr i
}
}
#puts "There are $i atoms selected."
close $inStream
return $coords
}

set psffile [lindex $argv 0]
set lastimage [lindex $argv 1]
set swarmnum [lindex $argv 2]

set targstring "CB CA OR NR"

set startframe 0
set kres 20

mol new $psffile waitfor all 
set dG 0
set deltaG_file [open deltaG.dat w]
set dG_file [open Free_energy.dat w]

for {set i 0} {$i < $lastimage} {incr i} {
#mol addfile ./after_NVT_$i.pdb type pdb waitfor all molid 0
    
#mol addfile ./after_NVT_0.pdb type pdb waitfor all molid 0
mol addfile run_NVT/NVT_$i.dcd type dcd waitfor all first 100 molid 0
set nframes [molinfo 0 get numframes] 

### write last frame pdb file

set curralllist [atomselect 0 all frame last]
$curralllist writepdb before_swarm_$i.pdb

### calculate free energy

        set averagepos [atomselect 0 "not water and name $targstring"]
        if {$i==0} {
            set posipre [concat [measure avpos $averagepos first 1 last [expr $nframes-1] step 1]]
            set refpre [concat [getsimplecoor targnew$i.dat]]
            puts $posipre
            puts $refpre
            set fmeanpre {}
            foreach drefpre $refpre dposipre $posipre {
                set dfmeanpre [vecscale $kres [vecsub $drefpre $dposipre]]
                lappend fmeanpre $dfmeanpre
            }
        } else {
            set posinow [concat [measure avpos $averagepos first 1 last [expr $nframes-1] step 1]]
            set refnow [concat [getsimplecoor targnew$i.dat]]
            set fmeannow {}
            set deltaG 0
            foreach drefnow $refnow dposinow $posinow dfmeanpre $fmeanpre dposipre $posipre {
                set dfmeannow [vecscale $kres [vecsub $drefnow $dposinow]]
                lappend fmeannow $dfmeannow
                set deltaG [expr $deltaG + [vecscale 0.5 [vecdot [vecadd $dfmeannow $dfmeanpre] [vecsub $dposinow $dposipre]]]]
            }
            puts $deltaG_file $deltaG
            set dG [expr $dG + $deltaG]
            puts $dG_file $dG
            set posipre $posinow
            set refpre $refnow
            set fmeanpre $fmeannow
        }
    animate delete all
}
close $deltaG_file
close $dG_file
    
    
    
    
    
    
