
#source qcprmsd.tcl
#source vectors.tcl
proc RMSD_VMD { cref ctarg } {
    # Compute RMSD
    return [FastRMSD [inner_prod $cref $ctarg] [llength $cref] 1]
}
proc getRotationMatrix_VMD { cref ctarg } {
    # 
    # Compute RMSD and rotation matrix
    set trans [FastRMSD [inner_prod $cref $ctarg] [llength $cref] 0]
    return $trans
}

set psffile [lindex $argv 0]
set startframe 0
set ImagIndex [lindex $argv 1]

set fitstring "OL NL CLP CL"
set targstring "CB CA OR NR"
#set add1 "CLP"
#set add2 "OL"
#set add3 "NL"

mol new $psffile
mol addfile ave.$startframe.pdb waitfor all

	set fitall [atomselect top all frame 0] 
	set fitlist [atomselect top "not water and name $fitstring" frame 0]
	set targlist [atomselect top "not water and name $targstring" frame 0]
	set fitCoM [measure center $fitlist weight mass]
	set fitCoords [$fitlist get {x y z}]
#	write frame 0
	$fitall set beta 0
	$fitlist set beta 1
	$fitall writepdb refcons_0.pdb

	set fitfile [open fit0.dat w]
	set targfile [open targ0.dat w]
	foreach coordfit [$fitlist get {x y z}] {
	puts $fitfile $coordfit
	}
	foreach coordtarg [$targlist get {x y z}]  {
	puts $targfile $coordtarg
	}
	close $fitfile
	close $targfile

for {set i $startframe} {$i < $ImagIndex} {incr i} {
	set J [expr { $i + 1 }]
	mol addfile ave.$J.pdb waitfor all
	set frame1 [expr $i]
	set frame2 [expr $i+1]

	set fitlist [atomselect top "not water and name $fitstring" frame $frame1]
	set targlist [atomselect top "not water and name $targstring" frame $frame1]
	set fitCoM [measure center $fitlist weight mass]

	set currfitlist [atomselect top "not water and name $fitstring" frame $frame2]
	set currtarglist [atomselect top  "not water and name $targstring" frame $frame2]
	set curralllist [atomselect top all frame $frame2]

	set currfitCoM [measure center $currfitlist weight mass]
#	set ndCoM [vecsub $fitCoM $currfitCoM]
#	$currfitlist moveby $ndCoM
#	$currtarglist moveby $ndCoM
	set mat [measure fit $currfitlist $fitlist weight mass]
	#$currfitlist move $mat
	#$currtarglist move $mat
	$curralllist move $mat
	puts [measure rmsd $currfitlist $fitlist]
	puts [measure rmsd $currtarglist $targlist]
	#VMD RMSD
	if {0} {
	puts -nonewline "   "
	puts -nonewline "VMD_RMSD: for fit atoms:"
	puts -nonewline [measure rmsd $currfitlist $fitlist]
	puts " ; for target atoms:"
	puts [measure rmsd $currtarglist $targlist]
	}
	$curralllist set beta 0
	$currfitlist set beta 1
	$curralllist update
	$currfitlist update
	$curralllist writepdb refcons_$frame2.pdb
	set fitfile [open fit$frame2.dat w]
	set targfile [open targ$frame2.dat w]
	foreach coordfit [$currfitlist get {x y z}] {
	puts $fitfile $coordfit
	}
	foreach coordtarg [$currtarglist get {x y z}]  {
	puts $targfile $coordtarg
	}
	close $fitfile
	close $targfile


}


