# multidimensial curve fitting

import sys
import numpy
import scipy
from scipy import optimize
from scipy import integrate
import numpy as np
import shutil
#   
#   read atominformation
#   
startimage=0
endimage=30
maximage=endimage-startimage+1
atomnum = 4	#number of atoms in reaction coordinates

#error_all = 0.1
maxiteration = 100
global sinP
P=6

atom=np.zeros((maximage,atomnum*3))
for i in range(maximage):
    f=open ("targ{0:d}.dat".format(i),"r")
    line=[]
    for rl in f:
	tl=rl.split()
	if (tl==''):
		continue
	line=line+tl
    atom[i]=line
    f.close()

def __func1(tk, x0, xM, omiga, P,atomnum):
    addsum=np.zeros(atomnum*3)
    for j in range(1,P+1):
	addsum=addsum + omiga.reshape(P,atomnum*3)[j-1]*np.sin(j*np.pi*abs(tk))
    return x0+(xM-x0)*abs(tk)+addsum

def __residual1(tk, f1, x0, xM, omiga, P,atomnum):
    return f1 - __func1(tk, x0, xM, omiga, P,atomnum)

def __func2(omiga, f2_0, f2_end, tk, P, startimage, endimage):
    addsum=np.zeros(endimage-startimage-1)
    for j in range(1,P+1):
	addsum=addsum + omiga[j-1]*np.sin(j*np.pi*abs(tk))
    return f2_0 + (f2_end-f2_0)*abs(tk) + addsum

def __residual2(omiga, f2, tk, P, startimage, endimage):
    return f2[(startimage+1):endimage] - __func2(omiga, f2[0], f2[endimage], tk, P, startimage, endimage)

def __residual1norm(tk, f1, x0, xM, omiga, P,atomnum):
    norm1 = numpy.linalg.norm(f1 - __func1(tk, x0, xM, omiga, P,atomnum))
    #print omiga
    #print norm1
    return norm1*norm1

def __tannorm(tk, x0, xM, omiga, P, atomnum):
    addsum=np.zeros(atomnum*3)
    for j in range(1,P+1):
	addsum=addsum + omiga.reshape(P,atomnum*3)[j-1]*(j*np.pi)*np.cos(j*np.pi*abs(tk))
    return numpy.linalg.norm((xM-x0)*1.0+addsum)


omiga=np.zeros((P*atomnum*3,))
tk=np.zeros(maximage)
tk[endimage]=1
p_cov1=np.zeros(maximage)
p_cov2=np.zeros(atomnum*3)
#arcf=np.zeros(maximage)
for i in range(maxiteration):
    for k in range(startimage+1,endimage):
	if (i==0):
		tk[k]=float(k)/maximage
	tk[k], p_cov1[k] = scipy.optimize.leastsq(__residual1, tk[k], args=(atom[k],atom[0], atom[endimage], omiga,P,atomnum))
#	print "{0:f} {1:f}".format(tk[k],p_cov1[k])
    for j in range(atomnum*3):
	omiga=omiga.reshape(P,atomnum*3)
	omiga.T[j], p_cov2[j] = scipy.optimize.leastsq(__residual2, omiga.T[j], args=(atom.T[j], tk[(startimage+1):endimage],P,startimage,endimage))
#	print "{0} {1:f} {2}".format(omiga.T[j],p_cov2[j],j)
    error_current=0
    omiga=omiga.reshape(P*atomnum*3,1)
#    print omiga
    print tk[:]
    for k in range(startimage+1,endimage):
	error_current=error_current + __residual1norm(tk[k], atom[k], atom[0], atom[endimage], omiga, P,atomnum)
	print "i{0} k{1} RMS error: {2}".format(i,k,np.sqrt(error_current))

# calculate arc length
for k in range(startimage,endimage+1):
   arcf=scipy.integrate.quad(__tannorm, 0, tk[k], args=(atom[0], atom[endimage], omiga,P,atomnum))
   #print __func1(0.4,atom[0],atom[endimage],omiga,P,atomnum)
   print "arc(t={0}): {1}".format(tk[k],arcf)
dtk=0.002
arcfend=scipy.integrate.quad(__tannorm, 0, 1, args=(atom[0], atom[endimage], omiga,P,atomnum))
print "arc total length:{0}".format(arcfend[0])
tknew=np.zeros(maximage)
for k in range(startimage+1,endimage):
   kestimate = (k / (maximage-1.0)) * arcfend[0]
   for ksearch in range(0,int(1.0/dtk)):
	tknew[k]=ksearch*dtk
	if ((scipy.integrate.quad(__tannorm, 0, tknew[k], args=(atom[0], atom[endimage], omiga,P,atomnum))[0]<=kestimate) and (scipy.integrate.quad(__tannorm, 0, tknew[k]+dtk, args=(atom[0], atom[endimage], omiga,P,atomnum))[0]>=kestimate)):
		print "kestimate:{0} for tknew:{1}".format(kestimate,tknew[k])
		break
beginindex=0
shutil.copy2('refcons_0.pdb','refNVT_0.pdb')
shutil.copy2('refcons_{0}.pdb'.format(endimage),'refNVT_{0}.pdb'.format(endimage))
for k in range(startimage+1,endimage):
   for l in range(beginindex,endimage):
	if ((abs(tk[l])<=tknew[k]) and (abs(tk[l+1])>=tknew[k])):
		if (abs(abs(tk[l])-tknew[k])<=abs(abs(tk[l+1])-tknew[k])):
			print "for tknew[{0}]:{1} find tk[{2}]:{3}".format(k,tknew[k],l,tk[l])
			beginindex=l
			shutil.copy2("refcons_{0:d}.pdb".format(l),"refNVT_{0:d}.pdb".format(k))
			break
		if (abs(abs(tk[l])-tknew[k])>abs(abs(tk[l+1])-tknew[k])):
			print "for tknew[{0}]:{1} find tk[{2}]:{3}".format(k,tknew[k],l+1,tk[l+1])
			beginindex=l
                        shutil.copy2("refcons_{0:d}.pdb".format(l+1),"refNVT_{0:d}.pdb".format(k))
			break

shutil.copy2('targ0.dat','targnew0.dat')
shutil.copy2('targ{0}.dat'.format(endimage),'targnew{0}.dat'.format(endimage))
coor=np.zeros((atomnum*3))
for k in range(startimage+1,endimage):
	coor=__func1(tknew[k],atom[0],atom[endimage],omiga,P,atomnum)
	coor=coor.reshape((atomnum,3))
	np.savetxt("targnew{0:d}.dat".format(k),coor)







