#!/bin/csh

# string method with swarms of trajectories implemented with NAMD

#---initialization---

set lastimage = 30; #index of the last image in the string
set swarmnum = 30; #number of trajectories in a swarm
set NUMREP = 30; #number of trajectories running in parallel
set NUMP = 16; #number of processors for an individual trajectory
set psffile = "./example/dipeptide.psf"
set NAMD = "/work/01680/wenma2/Development/NAMD_2.9_Source/Linux-x86_64-icc"
set VMD = "/work/01680/wenma2/Development/vmd-1.9.2a13/bin/vmd"

#---swarm of trajectories---
cd ../run_swarm
set D = 0
while ( $D <= $lastimage )
  set i = 1
  echo "submit swarm $D"
  set NPPre = 0
  while ( $i <= $swarmnum )
      @ NPnex = ( $NPPre + $NUMP )
      ibrun -n $NUMP -o $NPPre $NAMD/namd2 +pemap 0-15 swarm_$D.$i.namd >& swarm_$D.$i.log &
      set NPPre = $NPnex
    @ i += 1
  end
  wait
  @ D += 1
end
wait

#-----average the drift--------------------------
cd ../
set D = 0
while ( $D <= $lastimage )
    if ( -e get_trj_$D.out) then 
    rm -f get_trj_$D.out
    endif 
    @ k = ( $D + $NUMREP - 1 )
    set NPPre = 0
    while ($D <= $k)
      @ NPnex = ( $NPPre + $NUMP )
      ibrun -n 1 -o $NPPre $VMD -dispdev text -e ./scripts/get_trj.tcl -args $psffile $D $swarmnum > & get_trj_$D.out &
      @ D += 1
      set NPPre = $NPnex
    end 
    wait
end
wait

#--- align averaged structures and output pdbs -----
echo "after_ave.tcl"

ibrun -n 1 $VMD -dispdev text -e ./scripts/after_ave.tcl -args $psffile $lastimage > after_ave.log

echo "after_ave.tcl"

#------reparametrize the string-----------------
echo "repara begin \n"

module load python
ibrun -n 1 python multifit.py > multifit.log

ibrun -n 1 $VMD -dispdev text -e ./scripts/simplecoor_to_betapdb.tcl -args $psffile $lastimage > simplecoor_to_betapdb.log

echo "repara end \n"

#--- write colvar restraint files-----
echo "writing restraint files \n"

cd ./run_NVT
rm -f *.namd
rm -f harmonic_*.config
set com1 = `awk '{print $1}' ../center_of_mass.dat`
set com2 = `awk '{print $2}' ../center_of_mass.dat`
set com3 = `awk '{print $3}' ../center_of_mass.dat`

set D = 0
while ( $D <= $lastimage )
@ E = $D + 1
  set dcom1 = $com1[$E]
  set dcom2 = $com2[$E]
  set dcom3 = $com3[$E]
  sed "s/DDD/$D/" < ../NVT.namd > NVT_$D.namd
  sed -e "s/REFINDEX/$D/" -e "s/COMAAA/$dcom1/" -e "s/COMBBB/$dcom2/" -e "s/COMCCC/$dcom3/"<../harmonic.config> harmonic_$D.config
  @ D += 1
end
wait
cd ../

#---begin constraint runs---
cd ./run_NVT
set D = 0
while ( $D <= $lastimage )
  @ k = ( $D + $NUMREP - 1 )
  echo "submit constraint simulations from replica$D to replica$k"
  set NPPre = 0
  while ($D <= $k)
      @ NPnex = ( $NPPre + $NUMP )
      ibrun -n $NUMP -o $NPPre $NAMD/namd2 +pemap 0-15 NVT_$D.namd >& NVT_$D.log &
      @ D += 1
      set NPPre = $NPnex
  end 
  wait
end
wait
cd ../

#--- calculate free energy -----
echo "free_energy.tcl"

ibrun -n 1 $VMD -dispdev text -e ./scripts/free_energy.tcl -args $psffile $lastimage $swarmnum > free_energy.log

echo "free_energy.tcl"





