

proc getsimplecoor { fileName } {
    set inStream [open $fileName "r"] 	 
    set i 0
    set coords {}
    foreach line [split [read $inStream] \n] { 	
	set posiList [regexp -inline -all -- {\S+} $line] 
	set posi [split $posiList " "]
	set x [lindex $posi 0]
	set y [lindex $posi 1]
	set z [lindex $posi 2]
	if {[string is double -strict $x] && [string is double -strict $y] \
		&& [string is double -strict $z]} {
	lappend coords [concat $x $y $z] 
	incr i
	}
    }
    puts "There are $i atoms selected."
    close $inStream
    return $coords
}

set psffile [lindex $argv 0]
set startframe 0
set ImagIndex [lindex $argv 1]

mol new $psffile
set fitstring "OL NL CLP CL"
set targstring "CB CA OR NR"

for {set i $startframe} {$i <= $ImagIndex} {incr i} {
	mol addfile refNVT_$i.pdb waitfor all
	set Targfile targnew$i.dat
	set targCoords [getsimplecoor $Targfile]

	set currtarglist [atomselect top "not water and name $targstring" frame $i]
	set curralllist [atomselect top all frame $i]
	$curralllist set beta 0
	$currtarglist set beta 1
	$currtarglist set {x y z} $targCoords
	$curralllist writepdb targcons_$i.pdb
# --- write constraints for target and fit atoms ---
#	set currminilist [atomselect top "not water and name $targstring $fitstring" frame $i]
#        set curralllist [atomselect top all frame $i]
#        $curralllist set beta 0
#        $currminilist set beta 1
#        $curralllist writepdb minicons_$i.pdb

}

set restraintfile [open center_of_mass.dat w]

for {set i $startframe} {$i <= $ImagIndex} {incr i} {
set currfitlist [atomselect top "not water and name $fitstring" frame $i]
$currfitlist update

set com1 [measure center $currfitlist weight mass]

puts $restraintfile "[lindex $com1 0] [lindex $com1 1] [lindex $com1 2]"



}

close $restraintfile



exit
