#!/bin/csh -e

set lastimage = 30; #index of the last image in the string
set swarmnum = 30; #number of trajectories in a swarm
set psffile = "./example/dipeptide.psf"
set VMD = "/work/01680/wenma2/Development/vmd-1.9.2a13/bin/vmd"

mkdir run_NVT
mkdir run_swarm
cd ./run_swarm
set D = 0
while ( $D <= $lastimage )
  set i = 1
  while ( $i <= $swarmnum )
    if ( -e swarm_$D.$i.namd) then 
    rm -f swarm_$D.$i.*
    endif
    if ( -e swarm_$D.temp.namd) then 
    rm -f swarm_$D.temp.namd
    endif
    sed "s/DDD/$D/" < ../swarm.namd > swarm_$D.temp.namd
    sed "s/EEE/$i/" < swarm_$D.temp.namd > swarm_$D.$i.namd
    @ i += 1
  end
  wait
  @ D += $incrframe
end
wait
rm -f swarm_*.temp.namd

$VMD -dispdev text -e ./scripts/setup.tcl -args $psffile $lastimage

