
## Use soft wall potentials to perform milestoning with Voronoi Tessellation

source vectors.tcl

proc getsimpleindex { fileName } {
    set inStream [open $fileName "r"] 	 
    set i 0
    set atoms {}
    foreach line [split [read $inStream] \n] { 	 
	set atomindex [string trim [string range $line 0 5]] 	 
	if {[string is double -strict $atomindex]} { 
	lappend atoms $atomindex
	incr i
	}
    }
    print "There are $i atoms selected."
    close $inStream
    return $atoms  
}

proc getsimplecoor { fileName } {
    set inStream [open $fileName "r"] 	 
    set i 0
    set coords {}
    foreach line [split [read $inStream] \n] { 	
	set posiList [regexp -inline -all -- {\S+} $line] 
	set posi [split $posiList " "]
	set x [lindex $posi 0]
	set y [lindex $posi 1]
	set z [lindex $posi 2]
	if {[string is double -strict $x] && [string is double -strict $y] \
		&& [string is double -strict $z]} {
	set coords [ concat $coords [concat $x $y $z] ]
	#print "$x $y $z"
	incr i
	}
    }
    print "There are $i atoms selected."
    close $inStream
    return $coords
}

## initial setup 
    set totaltime 0
    set restraintFreq 1
    set staytime 0
    set prevstay 1
    set previndex -1
    set deltat 0

    print "targAtoms:"
    set targAtoms  [getsimpleindex $Targindex]
    puts $targAtoms
    print "targAtoms selection end"
    set targNum [llength $targAtoms]

	print "load the string centroids:"
        for {set i 0 } { $i < $replicanum } { incr i } {
		set string_centroid($i) [getsimplecoor [format "%s%d.dat" $centroidsfile $i]]
		set crosscount($i) 0
	}
	print "load $i string centroids end"

        for {set i 0 } { $i < $replicanum } { incr i } {
	        for {set j 0 } { $j < $replicanum } { incr j } {
			set Nij([expr $i*$replicanum+$j]) 0
		}
		set RTi($i) 0
	}

	set atom {}
	foreach atom $targAtoms {
	addatom $atom
	}

## force calculation procedure  
proc calcforces {} {
    global targAtoms targNum currforces kres totaltime restraintFreq printFreq string_centroid replicanum replicaindex crosscount staytime deltat Nij RTi previndex prevstay count_ofile Nij_ofile RTi_ofile

    if { [expr $totaltime % $restraintFreq ] == 0} {    
	loadcoords MDCoords
#	loadmasses MDmasses

	set currforces {}
	set currposi {}
	set stayflag 1
	set countbias 0
	set resenergy 0

	# check if crossing boundaries
	for {set i 0} {$i < $targNum } { incr i } {
		set atomidx [lindex $targAtoms $i]
		set currposi [concat $currposi $MDCoords($atomidx)]
	}
	
	# search from nearest neighbors, if there's one crossing happening, break the whole loop
        for {set j 1 } { $j < $replicanum } { incr j } {
		if {[expr $replicaindex + $j] < $replicanum} {
		set i [expr $replicaindex + $j]
		#print "$string_centroid($i) \n $string_centroid($replicaindex)"
		set normi [vecnorm [vecsub $string_centroid($i) $string_centroid($replicaindex)]]
		set midpoint [vecscale 0.5 [vecadd $string_centroid($i) $string_centroid($replicaindex)]]
		set projmid [vecdot $normi [vecsub $currposi $midpoint]]
		if { $projmid > 0} {
			if {$prevstay == 1} { 
				incr crosscount($i)
				print "into $i th cell at time: $totaltime"
				if {$previndex != -1} {
				print "previous milestone: $previndex"
				incr Nij([expr $previndex*$replicanum + $i])
				incr RTi($previndex) $deltat
				}
			}
			if {$currforces != {} } {
				set currforces [vecadd $currforces [vecscale [expr -1 * $kres * $projmid] $normi]]
			} else {
				set currforces [vecscale [expr -1 * $kres * $projmid] $normi]
			}
			set resenergy [expr $resenergy + [expr 0.5 * $kres * $projmid * $projmid]]
			set stayflag 0
			set prevstay 0
			set previndex $i
			incr countbias
			#break
		}
		}
		if {[expr $replicaindex - $j] > -1} {
		set i [expr $replicaindex - $j]
		set normi [vecnorm [vecsub $string_centroid($i) $string_centroid($replicaindex)]]
		set midpoint [vecscale 0.5 [vecadd $string_centroid($i) $string_centroid($replicaindex)]]
		set projmid [vecdot $normi [vecsub $currposi $midpoint]]
		if { $projmid > 0} {
			if {$prevstay == 1} { 
				incr crosscount($i)
				print "into $i th cell at time: $totaltime"
                                if {$previndex != -1} {
                                print "previous milestone: $previndex"
                                incr Nij([expr $previndex*$replicanum + $i])
                                incr RTi($previndex) $deltat
				}
			}
			if {$currforces != {} } {
				set currforces [vecadd $currforces [vecscale [expr -1 * $kres * $projmid] $normi]]
			} else {
				set currforces [vecscale [expr -1 * $kres * $projmid] $normi]
			}
			set resenergy [expr $resenergy + [expr 0.5 * $kres * $projmid * $projmid]]
			set stayflag 0
			set prevstay 0
			set previndex $i
			incr countbias
			#break
		}
		}
	}
	
	# check if the stayflag is turned off
	if {$stayflag == 1} {
		incr staytime
		if {$j != $replicanum} { 
			print "didnot go through all the images!"
			return
		}
		if {$prevstay != 1} {
		# if previous step is outside the cell
			print "back to the cell from $previndex th cell at time: $totaltime"
			set deltat 0
		}
		incr deltat
		set prevstay 1
	}

	if { [expr $totaltime % $printFreq ] == 0} {    
		print "writing statics files at time: $totaltime"
		if {$totaltime==0} { 
			set outfile [open $count_ofile w] 
			set outfileNij [open $Nij_ofile w]
			set outfileRTi [open $RTi_ofile w]
		} else { 
			set outfile [open $count_ofile a+] 
			set outfileNij [open $Nij_ofile a+]
                        set outfileRTi [open $RTi_ofile a+]
		}	
		puts $outfile "## time: $totaltime; stay-inside time: $staytime"
		puts -nonewline $outfileNij "TIME$totaltime "
		puts -nonewline $outfileRTi "TIME$totaltime "
		for {set i 0 } { $i < $replicanum } { incr i } {
			puts -nonewline $outfile "$crosscount($i) "
			for {set j 0} { $j < $replicanum } { incr j } {
			puts -nonewline $outfileNij "$Nij([expr $i*$replicanum + $j]) "
			}
			puts -nonewline $outfileRTi "$RTi($i) "
		}
		puts $outfile " "
		puts $outfileNij " "
		puts $outfileRTi " "
		close $outfile
		close $outfileNij
		close $outfileRTi
	}
		#clearconfig
   	} 
    
    if {$currforces != {} } {
	set i 0
	foreach currAtom $targAtoms {
		set forcex [lindex $currforces $i]
		incr i
		set forcey [lindex $currforces $i]
		incr i
		set forcez [lindex $currforces $i]
		incr i
		addforce $currAtom "$forcex $forcey $forcez"
		addenergy $resenergy
	}
	set numforces [expr $i]
	print "number of added forces ($numforces D): $countbias at time: $totaltime"
	if {[expr $numforces / 3] != $targNum} { print "number of added forces / 3 not match atom number!" }
    }
    if {$currforces == {} } {
	set i 0
	foreach currAtom $targAtoms {
	addforce $currAtom "0 0 0"
	addenergy $resenergy
	}
    }

    incr totaltime
    return
}





