#!/bin/csh

set PPN = 16

if ( $# < 2 ) then
  echo "This script requires two arguments:"
  echo "  number of nodes per replica (number of cores / $PPN)"
  echo "  number of replica in one cycle"
  echo '  queue (defaults to "normal", other option is "test")'
  exit -1
endif

set CONFFILE = replica_ms.sh
set NUMNODES = $1
shift
set NUMREP = $1
shift

set QUEUE = normal

if ( $# ) set QUEUE = $1

set TIME = 24:00:00

@ EACHREALNUMPROCS = $NUMNODES * $PPN
@ REALNUMPROCS = $EACHREALNUMPROCS * $NUMREP
@ REALNODES = $NUMNODES * $NUMREP

echo "Submitting NAMD run to queue $QUEUE for $TIME..."
echo "EACHREALNUMPROCS:$EACHREALNUMPROCS REALNUMPREOCS:$REALNUMPROCS REALNODES:$REALNODES NUMREP:$NUMREP "
sbatch -J milestoning --nodes=$REALNODES --ntasks=$REALNUMPROCS --time=$TIME --partition=$QUEUE $CONFFILE

