#!/bin/csh 

set BINDIR=/home1/00288/tg455591/NAMD_build.latest/NAMD_2.9_Linux-x86_64-MVAPICH-Intel-Stampede
set num_cell = 20; #number of cells
set NUMREP = $num_cell; #number of trajectories running in parallel, use the default value
set NUMP = 16; #number of processors for an individual trajectory

module load fftw3

set D = 0
while ( $D < $num_cell )
  @ k = ( $D + $NUMREP - 1 )
  echo "submit from replica$D to replica$k"
  set NPPre = 0
  while ($D <= $k)
      @ NPnex = ( $NPPre + $NUMP )
      ibrun -n $NUMP -o $NPPre $BINDIR/namd2 +pemap 0-15 ms_$D.namd >& ms_$D.log &
      @ D += 1
      set NPPre = $NPnex
  end 
  wait
end

