#!/bin/bash

# rrre binary
RRRE=../../../src/rrre

# NAMD log file
LOGFILE="../2-smd/pro-smd.log"

# extract the trajectories from the NAMD log file
# the forward trajectories
cat $LOGFILE | grep "SMD:  1" | awk '{print $4,$5,$6,$7}' > traj.txt
# the reverse trajectories
cat $LOGFILE | grep "SMD:  3" | awk '{print $4,$5,$6,$7}' >> traj.txt

# identify the path based on the intermediate (1:negative,2:psitive)
cat traj.txt | awk '$1==50000{print (($2<0)?1:2)}' > path.txt

# run the rrre code
$RRRE rrre.prm < traj.txt > rrre.out

# extract the free energies from the output file
cat rrre.out | grep "UFE " > g.txt
cat rrre.out | grep "PFE " > f.txt
