#!/bin/bash

# extracting the trajectories from SMD output files
rm traj.txt path.txt
for i in `seq -w 1 100`
do
    # a forward trajectory
    cat ../1-smd/forward/ncsu-smd-0$i.txt | awk '$1!~/#/{print $2,$11}' >> traj.txt
    # a reverse trajectory
    cat ../1-smd/reverse/ncsu-smd-0$i.txt | awk '$1!~/#/{print $2,$11}' >> traj.txt
    # identifying the pathway class of each trajectory based on the intermediate (1:TC,2:CT)
    cat ../1-smd/forward/ncsu-smd-0$i.txt | awk 'NR==104{print (($3<0)?1:2)}' >> path.txt
    cat ../1-smd/reverse/ncsu-smd-0$i.txt | awk 'NR==104{print (($3<0)?1:2)}' >> path.txt
done

# running the rrre program
../../../src/rrre rrre.prm < traj.txt > rrre.out

# extracting the free energies
cat rrre.out | grep "UFE " > g.txt
cat rrre.out | grep "PFE " > g.txt
