#!/bin/sh

SANDER="sander.MPI"
PRMTOP="../pp.prmtop"

for n in `seq -w 1 100`
do

INPCRD="../pp2/pp.0$n"
RSTRT="pp.0$n"

cat > mdin.$n << EOF
SMD $n
&cntrl
  imin = 0, irest = 0, igb = 2, gbsa = 1,
  ntx  = 1, ntb   = 0, ntt = 3, gamma_ln = 1.0,
  temp0 = 300.0, ig = -1,
  tol = 0.000001, ntc = 2, ntf = 2,
  cut = 256.0, dt = 0.001,
  ntpr = 20000000,
  ntwr = 20000000,
  ntwx = 0,
  nstlim = 20000000,
  nscm = 100,
  ntr = 0, ipol = 0
&end

ncsu_smd

variable
type = COS_OF_DIHEDRAL
i = (2, 5, 7, 17, 17, 19, 21, 31)
path = (-2.0, 2.0)
harm = (100.0)
end variable

variable
type = COS_OF_DIHEDRAL
i = (2, 5, 7, 17)
path = (-1.0, 1.0)
harm = (0.0)
end variable

variable
type = COS_OF_DIHEDRAL
i = (17, 19, 21, 31)
path = (-1.0, 1.0)
harm = (0.0)
end variable

output_freq = 100000
output_file = 'ncsu-smd-0$n.txt'

end ncsu_smd

EOF


mpiexec "$SANDER" -O              \
          -i "mdin.0$n"           \
          -o "mdout.0$n"          \
          -x "mdcrd.0$n"          \
          -c "${INPCRD}"         \
          -p "${PRMTOP}"         \
          -inf "mdinfo.0$n"       \
          -r "pp.0$n" || exit 1
done

