#!/bin/bash

# example of gwham usage with Bayesian bootstrapping

# firs step: preparing the data (potentials from the colvar trajectories)

N=12 # number of replicas
ROOT="my/trajectory/files/root" # e.g. ../../US/rotate.job
x0="0.0 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0 11.0" # these are my centers
k="1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0" # these are my harmonic constants

if [ -f data.txt ]; then rm data.txt; fi # the data will be collected here

for l in `seq 2 8` # these are runs that I will consider for wham (job2,job3,...). Here, I will consider each job as an independent block.
do
for i in `seq 0 $((N-1))` # these are my replicas
do
    cat ${ROOT}${l}.${i}.sort.colvars.traj | \
    awk -v N=$N -v i=$i -v k="$k" -v x0="$x0" -v l=$((l-2)) '
    BEGIN{
	split(x0,X0)
	split(k,K)
    }($1 !~ /#/){
	    t=$1
	    x=$2
	    printf "%d %d %d",i,l,t
	    for (j=1;j<=N;j++) printf " %f",0.5*K[j]*(x-X0[j])*(x-X0[j])
	    printf "\n"
	}' >> data.txt
done
done

# second step: run the gwham with bootstrapping

l=`wc data.txt | awk '{print $1}'` # number of data (you can use only a portion of the data)
./gwham -w $N -l $l -t 310 -b 7 -B 100 < data.txt > bootstrap.txt 2> bootstrap.err

# put alternative probabilities associated with each data point in one row
# each column will give one set of probabilities than can be used to build a histogram in terms of an arbitrary collective variable
cat density.txt | \
awk -v l=$l -v boot=100 '{
    i=(NR-1)%l
    p[$1,i]=$5
    if ($1==1) {
	W[i]=$2
	B[i]=$3
	T[i]=$4
    }
}END{
    for (i=0;i<l;i++) {
	printf "%s %s %s",W[i],B[i],T[i]
	for(j=1;j<=boot;j++) printf " %s",p[j,i]
	printf "\n"
    }
}' > density

