#!/bin/bash

# example of gwham usage

# use ./gwham --help or ./gwham -h for help

# firs step: preparing the data (potentials from the colvar trajectories)

N=12 # number of replicas
ROOT="my/trajectory/files/root" # e.g. ../../US/rotate.job
x0="0.0 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0 11.0" # these are my centers
k="1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0" # these are my harmonic constants

if [ -f data.txt ]; then rm data.txt; fi # the data will be collected here

for l in `seq 2 8` # these are runs that I will consider for wham (job2,job3,...)
do
for i in `seq 0 $((N-1))` # these are my replicas
do
    cat ${ROOT}${l}.${i}.sort.colvars.traj | \
    awk -v N=$N -v i=$i -v k="$k" -v x0="$x0" '
    BEGIN{
	split(x0,X0)
	split(k,K)
    }($1 !~ /#/){
	    t=$1
	    x=$2
	    printf "%d %d",i,t
	    for (j=1;j<=N;j++) printf " %f",0.5*K[j]*(x-X0[j])*(x-X0[j])
	    printf "\n"
	}' >> data.txt
done
done

# second step: run the gwham

l=`wc data.txt | awk '{print $1}'` # number of data (you can use only a portion of the data)
./gwham -w $N -l $l -t 310 < data.txt > density.txt 2> density.err
# These probabilities can be used to build a histogram in terms of an arbitrary collective variable obtained from the same trajectories

