#!/bin/bash

# After running the simulation and using "analyze.sh" use this script to generate string.pdf

gnuplot << EOF

set size 1, 1.3
set terminal postscript eps solid color enhanced lw 3.0 "Times-Roman" 32
set key center top
set encoding iso_8859_1

set xlabel "{/Symbol f} (degrees)"
set ylabel "{/Symbol y} (degrees)" offset 2,0
set xrange [-180:180]
set yrange [-180:180]
set xtics 90
set ytics 90
set output "string.ps"

set key at 2,300
set multiplot

set origin 0,1
set title "N = 8 images\n M = 16 copies/image\n N.M = 128 replicas\n Equilibration = 0.98 ps/iteration\n Release = 0.02 ps/iteration" font ",20" offset -10,-1
plot "../FE.txt" u (\$1*180/pi):(\$2*180/pi):(\$3+24) w image t "", \
"centers.txt" u (\$1*180/pi):(\$2*180/pi) w lp lt 7 t "{/=20 initial path}", \
"centersR.out" u (\$2*180/pi):(\$3*180/pi) w l lt 0 t "{/=20 first 10 iterations}", \
"centersR.out" u (\$4*180/pi):(\$5*180/pi) w l lt 0 t "", \
"centersR.out" u (\$6*180/pi):(\$7*180/pi) w l lt 0 t "", \
"centersR.out" u (\$8*180/pi):(\$9*180/pi) w l lt 0 t "", \
"centersR.out" u (\$10*180/pi):(\$11*180/pi) w l lt 0 t "", \
"centersR.out" u (\$12*180/pi):(\$13*180/pi) w l lt 0 t "", \
"centersR.out" u (\$14*180/pi):(\$15*180/pi) w l lt 0 t "", \
"centersR.out" u (\$16*180/pi):(\$17*180/pi) w l lt 0 t "", \
"centersR.out" u (\$18*180/pi):(\$19*180/pi) w l lt 0 t "", \
"centersR.out" u (\$20*180/pi):(\$21*180/pi) w l lt 0 t "", \
"centersR.out" u (\$198*180/pi):(\$199*180/pi) w lp lt -1 t "{/=20 at iteration 100}"

set xlabel "iteration"
set ylabel "{/Symbol D} (dihedral r.m.s.d)" offset 2,0
set xrange [0:100]
set yrange [0:1.4]
set xtics 10
set ytics 0.2
set key inside top

set size 1,1
set origin 0,0
set title ""
plot "DS.txt" u 1:2 w l lt 1 lw 1 t "{/Symbol D}_{i,0}", \
"DS.txt" u 1:3 w l lt 3 lw 1 t "{/Symbol D}_{i,i-1}"

set nomultiplot


EOF

ps2epsi string.ps
epstopdf string.epsi
rm string.ps string.epsi
