#!/bin/bash

gnuplot << EOF

set size 1, 1
set terminal postscript eps solid color enhanced lw 3.0 "Times-Roman" 32
set key center top
set encoding iso_8859_1

set xlabel "iteration"
set ylabel "E_w/log(N)"
set xrange [0:100]
set yrange [0:0.45]
set output "fig-di-E.ps"

set multiplot

set origin 1,0
set title "(b)" offset 10,-2.5 font ",40"
plot \
"4-abmd-S/W.txt" u 1:6 w l lt 1 lw 2 t "{/Symbol e}=0", \
"5-abmd-S-0.001/W.txt" u 1:6 w l lt 9 lw 2 t "{/Symbol e}=0.001", \
"6-abmd-S-0.01/W.txt" u 1:6 w l lt 3 lw 2 t "{/Symbol e}=0.01"

set nokey
set title "(a)" offset 10,-2.5 font ",40"
set ylabel "w_i"
set yrange [0:1]
set origin 0,0
plot \
"4-abmd-S/W.txt" u 2 w l, \
"4-abmd-S/W.txt" u 3 w l, \
"4-abmd-S/W.txt" u 4 w l, \
"4-abmd-S/W.txt" u 5 w l, \
0.25 lt 0

set nomultiplot
set xlabel "{/Symbol f} (degrees)"
set ylabel "{/Symbol y} (degrees)"
set xrange [-180:180]
set yrange [-180:180]
set xtics 90
set ytics 90
set output "fig-di-FE.ps"

set multiplot

set origin 0,0
set title "(a)" offset -15,-15 font ",48"
plot "3-abmd/FE.txt" u (\$1*180/pi):(\$2*180/pi):3 w image

set origin 1,0
set title "(b)" offset -15,-15 font ",48"
plot "4-abmd-S/FE.txt" u (\$1*180/pi):(\$2*180/pi):3 w image
set nomultiplot


EOF

for f in FE E
do
    ps2epsi fig-di-$f.ps
    epstopdf fig-di-$f.epsi
done
rm *.ps *.epsi
