/* COPYRIGHT_BEGIN
 *    Copyright (c) 1991 SGI   All Rights Reserved
 *    THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF SGI
 *    The copyright notice above does not evidence any
 *    actual or intended publication of such source code,
 *    and is an unpublished work by Silicon Graphics, Inc.
 *    This material contains CONFIDENTIAL INFORMATION that
 *    is the property of Silicon Graphics, Inc. Any use,
 *    duplication or disclosure not specifically authorized
 *    by Silicon Graphics is strictly prohibited.
 *    
 *    RESTRICTED RIGHTS LEGEND:
 *    
 *    Use, duplication or disclosure by the Government is
 *    subject to restrictions as set forth in subdivision
 *    (c)(1)(ii) of the Rights in Technical Data and Computer
 *    Software clause at DFARS 52.227-7013, and/or in similar
 *    or successor clauses in the FAR, DOD or NASA FAR
 *    Supplement.  Unpublished- rights reserved under the
 *    Copyright Laws of the United States.  Contractor is
 *    SILICON GRAPHICS, INC., 2011 N. Shoreline Blvd.,
 *    Mountain View, CA 94039-7311
 * COPYRIGHT_END */

/* 
 * Module generic routines subprogram for module WorldMap.
 * Automatically created by module builder at Wed Jan 13 15:58:04 1993.
 * 
 */


/* System include files. */
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#ifdef _CRAY
#include <fortran.h>
#endif

/* include files from $EXPLORERHOME/include  */
#include <cx/Typedefs.h>
#include <cx/ModuleCommand.h>
#include <cx/DataOps.h>
#include <cx/PortAccess.h>
#include <cx/Coerce.h>
#include <cx/cxMetaType.h>
#include <cx/TypeMismatchMsg.h>
#include <cx/UserFuncs.h>

#include <cx/UDT.h>

#include <cx/Info.h>

#include <cx/DataAccess.h>
#include <cx/cxParameter.api.h>
#include <cx/cxPyramid.api.h>

/* No user specified include files. */


#ifdef __cplusplus
	extern "C" {
#endif
/*****************************************************/

/* Entry points for MCW calling. */
extern long cxMDWmakemap(void);

cxFuncTable cx_FuncTable[] = {
		 (cxFuncTable)cxMDWmakemap,
		 NULL
};


extern cxMetaType cx_cxMetaTypeMetaType;
extern cxMetaType cx_cxParameterMetaType;
extern cxMetaType cx_cxPyramidMetaType;

void cxModuleMetaTypeInit(void) 
{
    cxMetaTypeAdd(&cx_cxMetaTypeMetaType);
    cxMetaTypeAdd(&cx_cxParameterMetaType);
    cxMetaTypeAdd(&cx_cxPyramidMetaType);

}

/*****************************************************/

/* Entry points for Hook Function calling. */

cxHookTable cx_HookTable[] = {
    { cx_func_last}
};
/*****************************************************/
/* Check Input ports against constraints in module resources. */
cxErrorCode cxPortCheckIn ( int portC, void *ports[], long *cxMDWPortID ) 
{
  cxErrorCode   ec;
  int           portOK;
  void         *cxChkDat;
  char          buf[128], *portData, *msg;


  /* Can't do port checking on alternate executables. */

  if (strcmp( "WorldMap", cxModuleNameGet()) != NULL)
    return cx_err_none;
  /* Can't do port checking on variable # ports. */

  if (portC != 16)
    return cx_err_none;
  /* Checking contents of Input datasets. */

  /* No typing information for port 0. */

  /* No typing information for port 1. */

  /* No typing information for port 2. */

  /* No typing information for port 3. */

  /* No typing information for port 4. */

  /* No typing information for port 5. */

  /* No typing information for port 6. */

  /* No typing information for port 7. */

  /* No typing information for port 8. */

  /* No typing information for port 9. */

  /* No typing information for port 10. */

  /* No typing information for port 11. */

  /* No typing information for port 12. */

  /* No typing information for port 13. */

  /* No typing information for port 14. */

  /* No typing information for port 15. */

  return cx_err_none;
}
/*****************************************************/
/* Check Output ports against constraints in module resources. */
cxErrorCode cxPortCheckOut ( int portC, void *ports[], long *cxMDWPortID ) 
{
  cxErrorCode   ec;
  int           portOK;
  void         *cxChkDat;
  char          buf[128], *portData, *msg;


  /* Can't do port checking on alternate executables. */

  if (strcmp( "WorldMap", cxModuleNameGet()) != NULL)
    return cx_err_none;
  /* Can't do port checking on variable # ports. */

  if (portC != 1)
    return cx_err_none;
  /* Checking contents of Output datasets. */
  cxChkDat  = ports[0];
  if (cxChkDat) {
    /* Only check optional port when it has data */
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxLattice *) 1) <= ((cxPyramid *) cxChkDat)->baseLattice);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->baseLattice );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Output", 
		    "cxPyramid", 
		    "Base Lattice", 
		    "->baseLattice", 
		    portData, 
		    "((cxLattice *) 1)", 
		    "" );
      cxOutputDataSet( cxMDWPortID[0], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (1 == ((cxPyramid *) cxChkDat)->count);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->count );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Output", 
		    "cxPyramid", 
		    "Num Levels", 
		    "->count", 
		    portData, 
		    "1", 
		    "1" );
      cxOutputDataSet( cxMDWPortID[0], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxPyramid *) cxChkDat)->ref.dictionary || 
	(1 <= ((cxPyramid *) cxChkDat)->ref.dictionary->nDim);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->ref.dictionary->nDim );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Output", 
		    "cxPyramid", 
		    "Num Dimensions", 
		    "->ref.dictionary->nDim", 
		    portData, 
		    "1", 
		    "" );
      cxOutputDataSet( cxMDWPortID[0], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (cx_compress_none == ((cxPyramid *) cxChkDat)->ref.compressType);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxPyramid *) cxChkDat)->ref.compressType, 
				"cxCompressType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->ref.compressType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Output", 
		    "cxPyramid", 
		    "Compression Type", 
		    "->ref.compressType", 
		    portData, 
		    "cx_compress_none", 
		    "cx_compress_none" );
      cxOutputDataSet( cxMDWPortID[0], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  }

  return cx_err_none;
}

#ifdef __cplusplus
}
#endif

