.TH WORLDMAP 1EXP
.SH NAME
WorldMap
.SH DESCRIPTION
.PP
The WorldMap module reads a compressed version of the "CIA
World Data Bank II map database" and produces a two-layer pyramid 
which contains a cropped, decimated map, in units of degrees longitude 
and degrees latitude, containing only those features selected by the user.
.SH WIDGETS
.TP
.BI "CIA Map Directory" " -- Text"
Should be set to the directory 
in which the CIA and plate boundary maps may be found. The CIA 
maps are included with this module or are 
available by anonymous ftp from hanauma.stanford.edu 
(36.51.0.16). The compressed version found there will untar into a map 
directory with subdirectories named africa.Map, asia.Map, europe.Map, 
namer.Map, and samer.Map. The original database (not the compressed 
version used here) is available from the U.S. Government and is in the 
public domain. The USGS_plates.txt file included with this module 
should be added to the map directory if you need plate boundary maps. 
The maps consume about 13 megabytes of disk space.
.TP
.BI "Precision" " -- Text"
Should be set to the size, in seconds, of 
the largest feature which the decimation routine will eliminate. Usually 
this should be no higher that 3600 seconds (1 degree). A setting of 1 
second will include all features since raw map coordinates are in integer 
numbers of seconds. Most features on the map appear to be on the order 
of thirty seconds. The decimation algorithm operates by combining as 
many line segments smaller than precision as possible such that their 
total vector length is still less than Precision into a single line segment. 
This will tend to eliminate features smaller than Precision and small 
islands may be reduced to a segment of zero length.
.sp
Remember that the map files are greatly compressed and when 
read into memory the map will be much larger. It is best to start at lower 
resolution with fewer features and build up than to attempt to read in the 
entire map at full resolution. One must use less resolution when looking 
at large areas and higher resolution when zooming in. This will also 
improve the drawing time for the map.
.TP
.BI "International" " -- Option Menu"
Selects international political boundaries which are not something else
(coastlines, rivers, etc.).  This option menu, like
most of the option menus (see exceptions below), operates on the 
principle that if you want, for example, Minor Rivers, you also want 
Major Rivers. Therefore selecting a feature on an option menu implies 
selecting all features above it on the menu as well. Of course some 
options, such as Plates, are simply all or none.
.TP
.BI "National" " -- Option Menu"
Selects national political boundaries, specifically U.S. states
and Canadian provinces.  No other national political boundaries
are in the map data base.
.TP
.BI "Coasts, Islands, and Lakes" " -- Option Menu"
Selects coasts, islands, and lakes.
.TP
.BI "Rivers" " -- Option Menu"
Selects rivers.
.TP
.BI "Reefs, etc." " -- Option Menu"
Selects reefs and/or salt pans.  Combined because of the limited
number of input ports allowed by explorer.
.TP
.BI "Ice" " -- Option Menu"
Selects glaciers and ice shelves.
.TP
.BI "Canals" " -- Option Menu"
Selects canals.
.TP
.BI "Plates" " -- Option Menu"
Selects tectonic plate boundaries.
.TP
.BI "Parallels" " -- Option Menu"
Selects latitude grid lines.
.TP
.BI "Meridians" " -- Option Menu"
Selects longitude grid lines.
.TP
.BI "Min Longitude" " -- Text"
Sets minimum longitude, may be any number less than maximum longitude.
.TP
.BI "Max Longitude" " -- Text"
Sets maximum longitude, may be any number greater than minimum longitude.
The map can extend for more than 360 degress.
.TP
.BI "Min Latitude" " -- Text"
Sets minimum latitude, must be greater than -90 and less than maximum
latitude.
.TP
.BI "Max Latitude" " -- Text"
Sets maximum latitude, must be less than 90 and greater than minimum 
latitude.
.SH OUTPUTS
.TP
.BI "Output" " -- Pyramid"
(1-layer, 1..-baseLat, n-D compression, none-compression type).
Pyramid which contains the map.
The output pyramid follows the finite element convention and is 
suitable for feeding into PyrToGeom. The coordinates are curvilinear 
and of the form (longitude, latitude, 0.0). There is a single data variable 
which is set to a number from 0 to 99 depending on the particular 
feature that is represented. When a colormap is used with PyrToGeom, 
this data allows each feature to have different color.
.sp
Map Feature Color Numbers
.sp
 1	Demarcated or delimited international boundary
 2	Indefinite or in dispute international boundary
 3	Other line of separation of sovereignty on land
 21	Demarcated or delimited national boundary
 22	Indefinite or in dispute national boundary
 23	Other national boundary
 41	Coasts, islands and lakes on most maps
 42	Additional major islands and lakes
 43	Intermediate islands and lakes
 44	Minor islands and lakes
 46	Intermittent major lakes
 47	Intermittent minor lakes
 48	Reefs
 49	Salt pans-major
 50	Salt pans-minor
 53	Ice shelves-major
 54	Ice shelves-minor
 55	Glaciers
 61	Permanent major rivers
 62	Additional major rivers
 63	Additional rivers
 64	Minor rivers
 65	Double lined rivers
 66	Intermittent rivers-major
 67	Intermittent rivers-additional
 68	Intermittent rivers-minor
 70	Major canals
 71	Canals of lesser importance
 72	Canals-irrigation type
 81	Plate boundaries
 99	Grid lines / BendBox output
.SH KNOWN PROBLEMS
Large maps may fragment arena memory.
.SH SEE ALSO
Projector, PyrToGeom, WorldCrop.
