/* COPYRIGHT_BEGIN
 *    Copyright (c) 1991 SGI   All Rights Reserved
 *    THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF SGI
 *    The copyright notice above does not evidence any
 *    actual or intended publication of such source code,
 *    and is an unpublished work by Silicon Graphics, Inc.
 *    This material contains CONFIDENTIAL INFORMATION that
 *    is the property of Silicon Graphics, Inc. Any use,
 *    duplication or disclosure not specifically authorized
 *    by Silicon Graphics is strictly prohibited.
 *    
 *    RESTRICTED RIGHTS LEGEND:
 *    
 *    Use, duplication or disclosure by the Government is
 *    subject to restrictions as set forth in subdivision
 *    (c)(1)(ii) of the Rights in Technical Data and Computer
 *    Software clause at DFARS 52.227-7013, and/or in similar
 *    or successor clauses in the FAR, DOD or NASA FAR
 *    Supplement.  Unpublished- rights reserved under the
 *    Copyright Laws of the United States.  Contractor is
 *    SILICON GRAPHICS, INC., 2011 N. Shoreline Blvd.,
 *    Mountain View, CA 94039-7311
 * COPYRIGHT_END */

/* 
 * Module generic routines subprogram for module Projector.
 * Automatically created by module builder at Fri Jan 15 07:28:22 1993.
 * 
 */


/* System include files. */
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#ifdef _CRAY
#include <fortran.h>
#endif

/* include files from $EXPLORERHOME/include  */
#include <cx/Typedefs.h>
#include <cx/ModuleCommand.h>
#include <cx/DataOps.h>
#include <cx/PortAccess.h>
#include <cx/Coerce.h>
#include <cx/cxMetaType.h>
#include <cx/TypeMismatchMsg.h>
#include <cx/UserFuncs.h>

#include <cx/UDT.h>

#include <cx/Info.h>

#include <cx/DataAccess.h>
#include <cx/cxPyramid.api.h>
#include <cx/cxLattice.api.h>
#include <cx/cxParameter.api.h>

/* No user specified include files. */


#ifdef __cplusplus
	extern "C" {
#endif
/*****************************************************/

/* Entry points for MCW calling. */
extern long cxMDWprojector(void);

cxFuncTable cx_FuncTable[] = {
		 (cxFuncTable)cxMDWprojector,
		 NULL
};


extern cxMetaType cx_cxMetaTypeMetaType;
extern cxMetaType cx_cxPyramidMetaType;
extern cxMetaType cx_cxLatticeMetaType;
extern cxMetaType cx_cxParameterMetaType;

void cxModuleMetaTypeInit(void) 
{
    cxMetaTypeAdd(&cx_cxMetaTypeMetaType);
    cxMetaTypeAdd(&cx_cxPyramidMetaType);
    cxMetaTypeAdd(&cx_cxLatticeMetaType);
    cxMetaTypeAdd(&cx_cxParameterMetaType);

}

/*****************************************************/

/* Entry points for Hook Function calling. */

cxHookTable cx_HookTable[] = {
    { cx_func_last}
};
/*****************************************************/
/* Check Input ports against constraints in module resources. */
cxErrorCode cxPortCheckIn ( int portC, void *ports[], long *cxMDWPortID ) 
{
  cxErrorCode   ec;
  int           portOK;
  void         *cxChkDat;
  char          buf[128], *portData, *msg;


  /* Can't do port checking on alternate executables. */

  if (strcmp( "Projector", cxModuleNameGet()) != NULL)
    return cx_err_none;
  /* Can't do port checking on variable # ports. */

  if (portC != 13)
    return cx_err_none;
  /* Checking contents of Input datasets. */
  cxChkDat  = ports[0];
  if (cxChkDat) {
    /* Only check optional port when it has data */
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxLattice *) 1) <= ((cxPyramid *) cxChkDat)->baseLattice);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->baseLattice );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Map", 
		    "cxPyramid", 
		    "Base Lattice", 
		    "->baseLattice", 
		    portData, 
		    "((cxLattice *) 1)", 
		    "" );
      cxInputDataRelease( cxMDWPortID[0] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (1 <= ((cxPyramid *) cxChkDat)->count);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->count );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Map", 
		    "cxPyramid", 
		    "Num Levels", 
		    "->count", 
		    portData, 
		    "1", 
		    "" );
      cxInputDataRelease( cxMDWPortID[0] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxPyramid *) cxChkDat)->ref.dictionary || 
	(1 <= ((cxPyramid *) cxChkDat)->ref.dictionary->nDim);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->ref.dictionary->nDim );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Map", 
		    "cxPyramid", 
		    "Num Dimensions", 
		    "->ref.dictionary->nDim", 
		    portData, 
		    "1", 
		    "" );
      cxInputDataRelease( cxMDWPortID[0] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (cx_compress_none == ((cxPyramid *) cxChkDat)->ref.compressType);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxPyramid *) cxChkDat)->ref.compressType, 
				"cxCompressType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->ref.compressType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Map", 
		    "cxPyramid", 
		    "Compression Type", 
		    "->ref.compressType", 
		    portData, 
		    "cx_compress_none", 
		    "cx_compress_none" );
      cxInputDataRelease( cxMDWPortID[0] );
      cxModAlert( msg );
      return cx_err_error;
      }
  }
  cxChkDat  = ports[1];
  if (cxChkDat) {
    /* Only check optional port when it has data */
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxLattice *) 1) <= ((cxPyramid *) cxChkDat)->baseLattice);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->baseLattice );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Pyramid 1", 
		    "cxPyramid", 
		    "Base Lattice", 
		    "->baseLattice", 
		    portData, 
		    "((cxLattice *) 1)", 
		    "" );
      cxInputDataRelease( cxMDWPortID[1] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (1 <= ((cxPyramid *) cxChkDat)->count);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->count );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Pyramid 1", 
		    "cxPyramid", 
		    "Num Levels", 
		    "->count", 
		    portData, 
		    "1", 
		    "" );
      cxInputDataRelease( cxMDWPortID[1] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxPyramid *) cxChkDat)->ref.dictionary || 
	(1 <= ((cxPyramid *) cxChkDat)->ref.dictionary->nDim);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->ref.dictionary->nDim );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Pyramid 1", 
		    "cxPyramid", 
		    "Num Dimensions", 
		    "->ref.dictionary->nDim", 
		    portData, 
		    "1", 
		    "" );
      cxInputDataRelease( cxMDWPortID[1] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (cx_compress_none == ((cxPyramid *) cxChkDat)->ref.compressType);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxPyramid *) cxChkDat)->ref.compressType, 
				"cxCompressType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->ref.compressType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Pyramid 1", 
		    "cxPyramid", 
		    "Compression Type", 
		    "->ref.compressType", 
		    portData, 
		    "cx_compress_none", 
		    "cx_compress_none" );
      cxInputDataRelease( cxMDWPortID[1] );
      cxModAlert( msg );
      return cx_err_error;
      }
  }
  cxChkDat  = ports[2];
  if (cxChkDat) {
    /* Only check optional port when it has data */
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxLattice *) 1) <= ((cxPyramid *) cxChkDat)->baseLattice);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->baseLattice );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Pyramid 2", 
		    "cxPyramid", 
		    "Base Lattice", 
		    "->baseLattice", 
		    portData, 
		    "((cxLattice *) 1)", 
		    "" );
      cxInputDataRelease( cxMDWPortID[2] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (1 <= ((cxPyramid *) cxChkDat)->count);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->count );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Pyramid 2", 
		    "cxPyramid", 
		    "Num Levels", 
		    "->count", 
		    portData, 
		    "1", 
		    "" );
      cxInputDataRelease( cxMDWPortID[2] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxPyramid *) cxChkDat)->ref.dictionary || 
	(1 <= ((cxPyramid *) cxChkDat)->ref.dictionary->nDim);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->ref.dictionary->nDim );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Pyramid 2", 
		    "cxPyramid", 
		    "Num Dimensions", 
		    "->ref.dictionary->nDim", 
		    portData, 
		    "1", 
		    "" );
      cxInputDataRelease( cxMDWPortID[2] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (cx_compress_none == ((cxPyramid *) cxChkDat)->ref.compressType);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxPyramid *) cxChkDat)->ref.compressType, 
				"cxCompressType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->ref.compressType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Pyramid 2", 
		    "cxPyramid", 
		    "Compression Type", 
		    "->ref.compressType", 
		    portData, 
		    "cx_compress_none", 
		    "cx_compress_none" );
      cxInputDataRelease( cxMDWPortID[2] );
      cxModAlert( msg );
      return cx_err_error;
      }
  }
  cxChkDat  = ports[3];
  if (cxChkDat) {
    /* Only check optional port when it has data */
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxLattice *) 1) <= ((cxPyramid *) cxChkDat)->baseLattice);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->baseLattice );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Pyramid 3", 
		    "cxPyramid", 
		    "Base Lattice", 
		    "->baseLattice", 
		    portData, 
		    "((cxLattice *) 1)", 
		    "" );
      cxInputDataRelease( cxMDWPortID[3] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (1 <= ((cxPyramid *) cxChkDat)->count);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->count );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Pyramid 3", 
		    "cxPyramid", 
		    "Num Levels", 
		    "->count", 
		    portData, 
		    "1", 
		    "" );
      cxInputDataRelease( cxMDWPortID[3] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxPyramid *) cxChkDat)->ref.dictionary || 
	(1 <= ((cxPyramid *) cxChkDat)->ref.dictionary->nDim);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->ref.dictionary->nDim );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Pyramid 3", 
		    "cxPyramid", 
		    "Num Dimensions", 
		    "->ref.dictionary->nDim", 
		    portData, 
		    "1", 
		    "" );
      cxInputDataRelease( cxMDWPortID[3] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (cx_compress_none == ((cxPyramid *) cxChkDat)->ref.compressType);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxPyramid *) cxChkDat)->ref.compressType, 
				"cxCompressType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->ref.compressType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Pyramid 3", 
		    "cxPyramid", 
		    "Compression Type", 
		    "->ref.compressType", 
		    portData, 
		    "cx_compress_none", 
		    "cx_compress_none" );
      cxInputDataRelease( cxMDWPortID[3] );
      cxModAlert( msg );
      return cx_err_error;
      }
  }
  cxChkDat  = ports[4];
  if (cxChkDat) {
    /* Only check optional port when it has data */
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxData *) 1) <= ((cxLattice *) cxChkDat)->data);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Data Structure", 
		    "->data", 
		    portData, 
		    "((cxData *) 1)", 
		    "" );
      cxInputDataRelease( cxMDWPortID[4] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxCoord *) 1) <= ((cxLattice *) cxChkDat)->coord);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->coord );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Coord Structure", 
		    "->coord", 
		    portData, 
		    "((cxCoord *) 1)", 
		    "" );
      cxInputDataRelease( cxMDWPortID[4] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (1 <= ((cxLattice *) cxChkDat)->nDim);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->nDim );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Num Dimensions", 
		    "->nDim", 
		    portData, 
		    "1", 
		    "" );
      cxInputDataRelease( cxMDWPortID[4] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->data || 
	(1 <= ((cxLattice *) cxChkDat)->data->nDataVar);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data->nDataVar );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Num Data Variables", 
		    "->data->nDataVar", 
		    portData, 
		    "1", 
		    "" );
      cxInputDataRelease( cxMDWPortID[4] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->data || 
	(cx_prim_byte <= ((cxLattice *) cxChkDat)->data->primType 
                         && ((cxLattice *) cxChkDat)->data->primType<= cx_prim_double);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxLattice *) cxChkDat)->data->primType, 
				"cxPrimType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data->primType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Primitive Data Type", 
		    "->data->primType", 
		    portData, 
		    "cx_prim_byte", 
		    "cx_prim_double" );
      cxInputDataRelease( cxMDWPortID[4] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->coord || 
	(cx_coord_uniform <= ((cxLattice *) cxChkDat)->coord->coordType 
                         && ((cxLattice *) cxChkDat)->coord->coordType<= cx_coord_curvilinear);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxLattice *) cxChkDat)->coord->coordType, 
				"cxCoordType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->coord->coordType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Coord Type", 
		    "->coord->coordType", 
		    portData, 
		    "cx_coord_uniform", 
		    "cx_coord_curvilinear" );
      cxInputDataRelease( cxMDWPortID[4] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->coord || 
	(3 == *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) ));
    if (!portOK) {
      sprintf( buf, "%d", *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) ) );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Num Coord Dimensions", 
		    "->coord->c.cx_coord_curvilinear.nCoordVar", 
		    portData, 
		    "3", 
		    "3" );
      cxInputDataRelease( cxMDWPortID[4] );
      cxModAlert( msg );
      return cx_err_error;
      }
  }
  cxChkDat  = ports[5];
  if (cxChkDat) {
    /* Only check optional port when it has data */
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxData *) 1) <= ((cxLattice *) cxChkDat)->data);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Data Structure", 
		    "->data", 
		    portData, 
		    "((cxData *) 1)", 
		    "" );
      cxInputDataRelease( cxMDWPortID[5] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxCoord *) 1) <= ((cxLattice *) cxChkDat)->coord);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->coord );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Coord Structure", 
		    "->coord", 
		    portData, 
		    "((cxCoord *) 1)", 
		    "" );
      cxInputDataRelease( cxMDWPortID[5] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (1 <= ((cxLattice *) cxChkDat)->nDim);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->nDim );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Num Dimensions", 
		    "->nDim", 
		    portData, 
		    "1", 
		    "" );
      cxInputDataRelease( cxMDWPortID[5] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->data || 
	(1 <= ((cxLattice *) cxChkDat)->data->nDataVar);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data->nDataVar );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Num Data Variables", 
		    "->data->nDataVar", 
		    portData, 
		    "1", 
		    "" );
      cxInputDataRelease( cxMDWPortID[5] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->data || 
	(cx_prim_byte <= ((cxLattice *) cxChkDat)->data->primType 
                         && ((cxLattice *) cxChkDat)->data->primType<= cx_prim_double);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxLattice *) cxChkDat)->data->primType, 
				"cxPrimType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data->primType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Primitive Data Type", 
		    "->data->primType", 
		    portData, 
		    "cx_prim_byte", 
		    "cx_prim_double" );
      cxInputDataRelease( cxMDWPortID[5] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->coord || 
	(cx_coord_uniform <= ((cxLattice *) cxChkDat)->coord->coordType 
                         && ((cxLattice *) cxChkDat)->coord->coordType<= cx_coord_curvilinear);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxLattice *) cxChkDat)->coord->coordType, 
				"cxCoordType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->coord->coordType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Coord Type", 
		    "->coord->coordType", 
		    portData, 
		    "cx_coord_uniform", 
		    "cx_coord_curvilinear" );
      cxInputDataRelease( cxMDWPortID[5] );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->coord || 
	(3 == *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) ));
    if (!portOK) {
      sprintf( buf, "%d", *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) ) );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_input, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Num Coord Dimensions", 
		    "->coord->c.cx_coord_curvilinear.nCoordVar", 
		    portData, 
		    "3", 
		    "3" );
      cxInputDataRelease( cxMDWPortID[5] );
      cxModAlert( msg );
      return cx_err_error;
      }
  }

  /* No typing information for port 6. */

  /* No typing information for port 7. */

  /* No typing information for port 8. */

  /* No typing information for port 9. */

  /* No typing information for port 10. */

  /* No typing information for port 11. */

  /* No typing information for port 12. */

  return cx_err_none;
}
/*****************************************************/
/* Check Output ports against constraints in module resources. */
cxErrorCode cxPortCheckOut ( int portC, void *ports[], long *cxMDWPortID ) 
{
  cxErrorCode   ec;
  int           portOK;
  void         *cxChkDat;
  char          buf[128], *portData, *msg;


  /* Can't do port checking on alternate executables. */

  if (strcmp( "Projector", cxModuleNameGet()) != NULL)
    return cx_err_none;
  /* Can't do port checking on variable # ports. */

  if (portC != 6)
    return cx_err_none;
  /* Checking contents of Output datasets. */
  cxChkDat  = ports[0];
  if (cxChkDat) {
    /* Only check optional port when it has data */
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxLattice *) 1) <= ((cxPyramid *) cxChkDat)->baseLattice);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->baseLattice );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Map", 
		    "cxPyramid", 
		    "Base Lattice", 
		    "->baseLattice", 
		    portData, 
		    "((cxLattice *) 1)", 
		    "" );
      cxOutputDataSet( cxMDWPortID[0], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (1 <= ((cxPyramid *) cxChkDat)->count);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->count );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Map", 
		    "cxPyramid", 
		    "Num Levels", 
		    "->count", 
		    portData, 
		    "1", 
		    "" );
      cxOutputDataSet( cxMDWPortID[0], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxPyramid *) cxChkDat)->ref.dictionary || 
	(1 <= ((cxPyramid *) cxChkDat)->ref.dictionary->nDim);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->ref.dictionary->nDim );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Map", 
		    "cxPyramid", 
		    "Num Dimensions", 
		    "->ref.dictionary->nDim", 
		    portData, 
		    "1", 
		    "" );
      cxOutputDataSet( cxMDWPortID[0], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (cx_compress_none == ((cxPyramid *) cxChkDat)->ref.compressType);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxPyramid *) cxChkDat)->ref.compressType, 
				"cxCompressType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->ref.compressType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Map", 
		    "cxPyramid", 
		    "Compression Type", 
		    "->ref.compressType", 
		    portData, 
		    "cx_compress_none", 
		    "cx_compress_none" );
      cxOutputDataSet( cxMDWPortID[0], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  }
  cxChkDat  = ports[1];
  if (cxChkDat) {
    /* Only check optional port when it has data */
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxLattice *) 1) <= ((cxPyramid *) cxChkDat)->baseLattice);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->baseLattice );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Pyramid 1", 
		    "cxPyramid", 
		    "Base Lattice", 
		    "->baseLattice", 
		    portData, 
		    "((cxLattice *) 1)", 
		    "" );
      cxOutputDataSet( cxMDWPortID[1], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (1 <= ((cxPyramid *) cxChkDat)->count);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->count );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Pyramid 1", 
		    "cxPyramid", 
		    "Num Levels", 
		    "->count", 
		    portData, 
		    "1", 
		    "" );
      cxOutputDataSet( cxMDWPortID[1], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxPyramid *) cxChkDat)->ref.dictionary || 
	(1 <= ((cxPyramid *) cxChkDat)->ref.dictionary->nDim);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->ref.dictionary->nDim );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Pyramid 1", 
		    "cxPyramid", 
		    "Num Dimensions", 
		    "->ref.dictionary->nDim", 
		    portData, 
		    "1", 
		    "" );
      cxOutputDataSet( cxMDWPortID[1], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (cx_compress_none == ((cxPyramid *) cxChkDat)->ref.compressType);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxPyramid *) cxChkDat)->ref.compressType, 
				"cxCompressType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->ref.compressType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Pyramid 1", 
		    "cxPyramid", 
		    "Compression Type", 
		    "->ref.compressType", 
		    portData, 
		    "cx_compress_none", 
		    "cx_compress_none" );
      cxOutputDataSet( cxMDWPortID[1], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  }
  cxChkDat  = ports[2];
  if (cxChkDat) {
    /* Only check optional port when it has data */
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxLattice *) 1) <= ((cxPyramid *) cxChkDat)->baseLattice);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->baseLattice );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Pyramid 2", 
		    "cxPyramid", 
		    "Base Lattice", 
		    "->baseLattice", 
		    portData, 
		    "((cxLattice *) 1)", 
		    "" );
      cxOutputDataSet( cxMDWPortID[2], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (1 <= ((cxPyramid *) cxChkDat)->count);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->count );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Pyramid 2", 
		    "cxPyramid", 
		    "Num Levels", 
		    "->count", 
		    portData, 
		    "1", 
		    "" );
      cxOutputDataSet( cxMDWPortID[2], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxPyramid *) cxChkDat)->ref.dictionary || 
	(1 <= ((cxPyramid *) cxChkDat)->ref.dictionary->nDim);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->ref.dictionary->nDim );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Pyramid 2", 
		    "cxPyramid", 
		    "Num Dimensions", 
		    "->ref.dictionary->nDim", 
		    portData, 
		    "1", 
		    "" );
      cxOutputDataSet( cxMDWPortID[2], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (cx_compress_none == ((cxPyramid *) cxChkDat)->ref.compressType);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxPyramid *) cxChkDat)->ref.compressType, 
				"cxCompressType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->ref.compressType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Pyramid 2", 
		    "cxPyramid", 
		    "Compression Type", 
		    "->ref.compressType", 
		    portData, 
		    "cx_compress_none", 
		    "cx_compress_none" );
      cxOutputDataSet( cxMDWPortID[2], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  }
  cxChkDat  = ports[3];
  if (cxChkDat) {
    /* Only check optional port when it has data */
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxLattice *) 1) <= ((cxPyramid *) cxChkDat)->baseLattice);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->baseLattice );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Pyramid 3", 
		    "cxPyramid", 
		    "Base Lattice", 
		    "->baseLattice", 
		    portData, 
		    "((cxLattice *) 1)", 
		    "" );
      cxOutputDataSet( cxMDWPortID[3], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (1 <= ((cxPyramid *) cxChkDat)->count);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->count );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Pyramid 3", 
		    "cxPyramid", 
		    "Num Levels", 
		    "->count", 
		    portData, 
		    "1", 
		    "" );
      cxOutputDataSet( cxMDWPortID[3], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxPyramid *) cxChkDat)->ref.dictionary || 
	(1 <= ((cxPyramid *) cxChkDat)->ref.dictionary->nDim);
    if (!portOK) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->ref.dictionary->nDim );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Pyramid 3", 
		    "cxPyramid", 
		    "Num Dimensions", 
		    "->ref.dictionary->nDim", 
		    portData, 
		    "1", 
		    "" );
      cxOutputDataSet( cxMDWPortID[3], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (cx_compress_none == ((cxPyramid *) cxChkDat)->ref.compressType);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxPyramid *) cxChkDat)->ref.compressType, 
				"cxCompressType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxPyramid *) cxChkDat)->ref.compressType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Pyramid 3", 
		    "cxPyramid", 
		    "Compression Type", 
		    "->ref.compressType", 
		    portData, 
		    "cx_compress_none", 
		    "cx_compress_none" );
      cxOutputDataSet( cxMDWPortID[3], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  }
  cxChkDat  = ports[4];
  if (cxChkDat) {
    /* Only check optional port when it has data */
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxData *) 1) <= ((cxLattice *) cxChkDat)->data);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Data Structure", 
		    "->data", 
		    portData, 
		    "((cxData *) 1)", 
		    "" );
      cxOutputDataSet( cxMDWPortID[4], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxCoord *) 1) <= ((cxLattice *) cxChkDat)->coord);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->coord );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Coord Structure", 
		    "->coord", 
		    portData, 
		    "((cxCoord *) 1)", 
		    "" );
      cxOutputDataSet( cxMDWPortID[4], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (1 <= ((cxLattice *) cxChkDat)->nDim);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->nDim );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Num Dimensions", 
		    "->nDim", 
		    portData, 
		    "1", 
		    "" );
      cxOutputDataSet( cxMDWPortID[4], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->data || 
	(1 <= ((cxLattice *) cxChkDat)->data->nDataVar);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data->nDataVar );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Num Data Variables", 
		    "->data->nDataVar", 
		    portData, 
		    "1", 
		    "" );
      cxOutputDataSet( cxMDWPortID[4], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->data || 
	(cx_prim_byte <= ((cxLattice *) cxChkDat)->data->primType 
                         && ((cxLattice *) cxChkDat)->data->primType<= cx_prim_double);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxLattice *) cxChkDat)->data->primType, 
				"cxPrimType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data->primType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Primitive Data Type", 
		    "->data->primType", 
		    portData, 
		    "cx_prim_byte", 
		    "cx_prim_double" );
      cxOutputDataSet( cxMDWPortID[4], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->coord || 
	(cx_coord_uniform <= ((cxLattice *) cxChkDat)->coord->coordType 
                         && ((cxLattice *) cxChkDat)->coord->coordType<= cx_coord_curvilinear);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxLattice *) cxChkDat)->coord->coordType, 
				"cxCoordType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->coord->coordType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Coord Type", 
		    "->coord->coordType", 
		    portData, 
		    "cx_coord_uniform", 
		    "cx_coord_curvilinear" );
      cxOutputDataSet( cxMDWPortID[4], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->coord || 
	(3 == *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) ));
    if (!portOK) {
      sprintf( buf, "%d", *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) ) );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 1", 
		    "cxLattice", 
		    "Num Coord Dimensions", 
		    "->coord->c.cx_coord_curvilinear.nCoordVar", 
		    portData, 
		    "3", 
		    "3" );
      cxOutputDataSet( cxMDWPortID[4], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  }
  cxChkDat  = ports[5];
  if (cxChkDat) {
    /* Only check optional port when it has data */
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxData *) ((cxData *) 1)) <= ((cxLattice *) cxChkDat)->data);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Data Structure", 
		    "->data", 
		    portData, 
		    "((cxData *) ((cxData *) 1))", 
		    "" );
      cxOutputDataSet( cxMDWPortID[5], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (((cxCoord *) ((cxCoord *) 1)) <= ((cxLattice *) cxChkDat)->coord);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->coord );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Coord Structure", 
		    "->coord", 
		    portData, 
		    "((cxCoord *) ((cxCoord *) 1))", 
		    "" );
      cxOutputDataSet( cxMDWPortID[5], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = (1 <= ((cxLattice *) cxChkDat)->nDim);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->nDim );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Num Dimensions", 
		    "->nDim", 
		    portData, 
		    "1", 
		    "" );
      cxOutputDataSet( cxMDWPortID[5], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->data || 
	(1 <= ((cxLattice *) cxChkDat)->data->nDataVar);
    if (!portOK) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data->nDataVar );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Num Data Variables", 
		    "->data->nDataVar", 
		    portData, 
		    "1", 
		    "" );
      cxOutputDataSet( cxMDWPortID[5], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->data || 
	(cx_prim_byte <= ((cxLattice *) cxChkDat)->data->primType 
                         && ((cxLattice *) cxChkDat)->data->primType<= cx_prim_double);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxLattice *) cxChkDat)->data->primType, 
				"cxPrimType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->data->primType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Primitive Data Type", 
		    "->data->primType", 
		    portData, 
		    "cx_prim_byte", 
		    "cx_prim_double" );
      cxOutputDataSet( cxMDWPortID[5], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->coord || 
	(cx_coord_uniform <= ((cxLattice *) cxChkDat)->coord->coordType 
                         && ((cxLattice *) cxChkDat)->coord->coordType<= cx_coord_curvilinear);
    if (!portOK) {
      portData = cxEnumNameOf( ((cxLattice *) cxChkDat)->coord->coordType, 
				"cxCoordType" );
    if ( !portData ) {
      sprintf( buf, "%d", ((cxLattice *) cxChkDat)->coord->coordType );
      portData = buf;
    }
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Coord Type", 
		    "->coord->coordType", 
		    portData, 
		    "cx_coord_uniform", 
		    "cx_coord_curvilinear" );
      cxOutputDataSet( cxMDWPortID[5], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  /* The inverted logic (!x ||) says succeed if NIL or proceed. */
  portOK = !((cxLattice *) cxChkDat)->coord || 
	(3 == *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) ));
    if (!portOK) {
      sprintf( buf, "%d", *( (signed long *)  cxCoordNumCoordDimsGet( ((cxLattice *) cxChkDat)->coord ) ) );
      portData = strdup( buf );
      msg = cxTypeMismatchPortMsg( 
		    cx_port_output, 
		    "Lattice 2", 
		    "cxLattice", 
		    "Num Coord Dimensions", 
		    "->coord->c.cx_coord_curvilinear.nCoordVar", 
		    portData, 
		    "3", 
		    "3" );
      cxOutputDataSet( cxMDWPortID[5], NULL );
      cxModAlert( msg );
      return cx_err_error;
      }
  }

  return cx_err_none;
}

#ifdef __cplusplus
}
#endif

