/* COPYRIGHT_BEGIN
 *    Copyright (c) 1991 SGI   All Rights Reserved
 *    THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF SGI
 *    The copyright notice above does not evidence any
 *    actual or intended publication of such source code,
 *    and is an unpublished work by Silicon Graphics, Inc.
 *    This material contains CONFIDENTIAL INFORMATION that
 *    is the property of Silicon Graphics, Inc. Any use,
 *    duplication or disclosure not specifically authorized
 *    by Silicon Graphics is strictly prohibited.
 *    
 *    RESTRICTED RIGHTS LEGEND:
 *    
 *    Use, duplication or disclosure by the Government is
 *    subject to restrictions as set forth in subdivision
 *    (c)(1)(ii) of the Rights in Technical Data and Computer
 *    Software clause at DFARS 52.227-7013, and/or in similar
 *    or successor clauses in the FAR, DOD or NASA FAR
 *    Supplement.  Unpublished- rights reserved under the
 *    Copyright Laws of the United States.  Contractor is
 *    SILICON GRAPHICS, INC., 2011 N. Shoreline Blvd.,
 *    Mountain View, CA 94039-7311
 * COPYRIGHT_END */

/* 
 * Module data wrapper subprogram for module BendBox.
 * Automatically created by module builder at Wed Jan 13 10:56:54 1993.
 * 
 */


/* System include files. */
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#ifdef _CRAY
#include <fortran.h>
#endif

/* include files from $EXPLORERHOME/include  */
#include <cx/Typedefs.h>
#include <cx/ModuleCommand.h>
#include <cx/DataOps.h>
#include <cx/PortAccess.h>
#include <cx/Coerce.h>
#include <cx/cxMetaType.h>
#include <cx/TypeMismatchMsg.h>
#include <cx/UserFuncs.h>

#include <cx/UDT.h>

#include <cx/Info.h>

#include <cx/DataAccess.h>
#include <cx/cxParameter.api.h>
#include <cx/cxPyramid.api.h>

/* No user specified include files. */



  /* --- User Fcn call prototype. --- */
#include <cx/cxParameter.api.h>
#include <cx/cxPyramid.api.h>

#ifdef __cplusplus
	extern "C" {
#endif

  void 	bendbox  (
	 long   	  x_grid, 
	 long   	  y_grid, 
	 long   	  z_grid, 
	 float  	  x_spacing, 
	 float  	  y_spacing, 
	 float  	  z_spacing, 
	 float  	  x_min, 
	 float  	  x_max, 
	 float  	  y_min, 
	 float  	  y_max, 
	 float  	  z_min, 
	 float  	  z_max, 
	 cxPyramid *	* box );

#ifdef __cplusplus
}
#endif


/* Number of user function arguments. */
#define cxMDWNARGbendbox 13

long cxMDWbendbox( )
{

/* ----- Beginning of port declarations ----- */

/* Port dataset variable declarations */

  cxParameter *cxP_In_X_Grid;
  cxParameter *cxP_In_Y_Grid;
  cxParameter *cxP_In_Z_Grid;
  cxParameter *cxP_In_X_Min;
  cxParameter *cxP_In_X_Max;
  cxParameter *cxP_In_Y_Min;
  cxParameter *cxP_In_Y_Max;
  cxParameter *cxP_In_Z_Min;
  cxParameter *cxP_In_Z_Max;
  cxParameter *cxP_In_X_Spacing;
  cxParameter *cxP_In_Y_Spacing;
  cxParameter *cxP_In_Z_Spacing;
  cxPyramid *cxP_Out_Box;

/* --- End of port and dataset declarations ---- */


/* -- Beginning of User Fcn variable declarations -- */

  long    x_grid; 
  long    y_grid; 
  long    z_grid; 
  float   x_spacing; 
  float   y_spacing; 
  float   z_spacing; 
  float   x_min; 
  float   x_max; 
  float   y_min; 
  float   y_max; 
  float   z_min; 
  float   z_max; 
  cxPyramid * box; 

/* ------ End of User Fcn declarations ------ */

  long   cxMDWi, cxMDWIrc;
  long   cxMDWIfCoerce[ cxMDWNARGbendbox ];
  char *cxMDWStr;
  long  cxMDWFuncRetCode;
  char  cxMDWFuncBuf[256];
  long  cxMDWLen;
  long  cxMDWPortIDIn[12];
  long  cxMDWPortIDOut[1];
  void *tmp;
  int  *cxMDWTypeTab;
  cxDataCheckErrorInfo  *cxMDWCheckErr;
  cxErrorCode   ec;
/* ------------------------------------------ */
/* ----- Beginning of Port Associations ----- */

/* -------- First executable statment ------- */


  /* Get input port handles. */ 
  cxMDWPortIDIn[0] = cxInputPortOpen( "X Grid" );
  cxMDWPortIDIn[1] = cxInputPortOpen( "Y Grid" );
  cxMDWPortIDIn[2] = cxInputPortOpen( "Z Grid" );
  cxMDWPortIDIn[3] = cxInputPortOpen( "X Min" );
  cxMDWPortIDIn[4] = cxInputPortOpen( "X Max" );
  cxMDWPortIDIn[5] = cxInputPortOpen( "Y Min" );
  cxMDWPortIDIn[6] = cxInputPortOpen( "Y Max" );
  cxMDWPortIDIn[7] = cxInputPortOpen( "Z Min" );
  cxMDWPortIDIn[8] = cxInputPortOpen( "Z Max" );
  cxMDWPortIDIn[9] = cxInputPortOpen( "X Spacing" );
  cxMDWPortIDIn[10] = cxInputPortOpen( "Y Spacing" );
  cxMDWPortIDIn[11] = cxInputPortOpen( "Z Spacing" );

  /* Get output port handles. */ 
  cxMDWPortIDOut[0] = cxOutputPortOpen( "Box" );

  /* Get dataset pointers. */ 
  cxP_In_X_Grid = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[0] );
  cxP_In_Y_Grid = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[1] );
  cxP_In_Z_Grid = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[2] );
  cxP_In_X_Min = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[3] );
  cxP_In_X_Max = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[4] );
  cxP_In_Y_Min = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[5] );
  cxP_In_Y_Max = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[6] );
  cxP_In_Z_Min = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[7] );
  cxP_In_Z_Max = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[8] );
  cxP_In_X_Spacing = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[9] );
  cxP_In_Y_Spacing = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[10] );
  cxP_In_Z_Spacing = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[11] );

  /* Initialize the coercion status flags. */
  for (cxMDWi=0; cxMDWi< cxMDWNARGbendbox; cxMDWi++) 
    cxMDWIfCoerce[cxMDWi] = TRUE;


  /* Assign user function values. */
  /* Extracting User Function variables from ports. */

  if (0 && !cxP_In_X_Grid) {
    x_grid = NULL;
    cxMDWIfCoerce[0] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_long );	/* return of type (long    *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_X_Grid, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_X_Grid, &ec ) ), 
	  cx_prim_long, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    x_grid = *(long    *) tmp;

    cxMDWIfCoerce[0] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Y_Grid) {
    y_grid = NULL;
    cxMDWIfCoerce[1] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_long );	/* return of type (long    *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Y_Grid, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Y_Grid, &ec ) ), 
	  cx_prim_long, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    y_grid = *(long    *) tmp;

    cxMDWIfCoerce[1] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Z_Grid) {
    z_grid = NULL;
    cxMDWIfCoerce[2] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_long );	/* return of type (long    *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Z_Grid, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Z_Grid, &ec ) ), 
	  cx_prim_long, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    z_grid = *(long    *) tmp;

    cxMDWIfCoerce[2] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_X_Spacing) {
    x_spacing = NULL;
    cxMDWIfCoerce[3] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_float );	/* return of type (float   *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_X_Spacing, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_X_Spacing, &ec ) ), 
	  cx_prim_float, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    x_spacing = *(float   *) tmp;

    cxMDWIfCoerce[3] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Y_Spacing) {
    y_spacing = NULL;
    cxMDWIfCoerce[4] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_float );	/* return of type (float   *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Y_Spacing, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Y_Spacing, &ec ) ), 
	  cx_prim_float, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    y_spacing = *(float   *) tmp;

    cxMDWIfCoerce[4] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Z_Spacing) {
    z_spacing = NULL;
    cxMDWIfCoerce[5] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_float );	/* return of type (float   *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Z_Spacing, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Z_Spacing, &ec ) ), 
	  cx_prim_float, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    z_spacing = *(float   *) tmp;

    cxMDWIfCoerce[5] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_X_Min) {
    x_min = NULL;
    cxMDWIfCoerce[6] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_float );	/* return of type (float   *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_X_Min, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_X_Min, &ec ) ), 
	  cx_prim_float, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    x_min = *(float   *) tmp;

    cxMDWIfCoerce[6] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_X_Max) {
    x_max = NULL;
    cxMDWIfCoerce[7] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_float );	/* return of type (float   *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_X_Max, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_X_Max, &ec ) ), 
	  cx_prim_float, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    x_max = *(float   *) tmp;

    cxMDWIfCoerce[7] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Y_Min) {
    y_min = NULL;
    cxMDWIfCoerce[8] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_float );	/* return of type (float   *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Y_Min, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Y_Min, &ec ) ), 
	  cx_prim_float, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    y_min = *(float   *) tmp;

    cxMDWIfCoerce[8] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Y_Max) {
    y_max = NULL;
    cxMDWIfCoerce[9] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_float );	/* return of type (float   *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Y_Max, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Y_Max, &ec ) ), 
	  cx_prim_float, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    y_max = *(float   *) tmp;

    cxMDWIfCoerce[9] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Z_Min) {
    z_min = NULL;
    cxMDWIfCoerce[10] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_float );	/* return of type (float   *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Z_Min, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Z_Min, &ec ) ), 
	  cx_prim_float, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    z_min = *(float   *) tmp;

    cxMDWIfCoerce[10] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Z_Max) {
    z_max = NULL;
    cxMDWIfCoerce[11] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_float );	/* return of type (float   *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Z_Max, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Z_Max, &ec ) ), 
	  cx_prim_float, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    z_max = *(float   *) tmp;

    cxMDWIfCoerce[11] = FALSE;
    cxVecDel( tmp );
  }
  /* Assigning constant User Function variables. */
  /* Assigning whether data has changed to User Function variables. */
  /* Allocation of User Function variables. */
  box = (cxPyramid *) NULL; 

  bendbox( x_grid, 
      y_grid, z_grid, x_spacing, y_spacing, 
      z_spacing, x_min, x_max, y_min, 
      y_max, z_min, z_max, &box );

  if (cxDataAllocErrorGet())
    return( cx_err_error );

/* Beginning of output port assembly. */

  /* Output port assembly for port "Box". */

  cxP_Out_Box = (cxPyramid *) box;








/* End of output port assembly. */


/* Free temporarily assigned user vars. */

  cxOutputDataSet( cxMDWPortIDOut[0], (void *)cxP_Out_Box );
  return( cx_err_none );
}
