#!/bin/bash

# set to NAMD binary
NAMD=/Projects/dhardy/namd_builds/NAMD_3.0b6_Linux-x86_64-multicore-CUDA/namd3

echo STMV NPT GPU-resident on 1 GPU
$NAMD +p8 +setcpuaffinity +devices 0 stmv_gpures_npt.namd |& tee out_stmv_gpures_npt_1.log

echo STMV NPT GPU-resident on 2 GPUs
$NAMD +p15 +pmepes 7 +setcpuaffinity +devices 0,1 stmv_gpures_npt.namd |& tee out_stmv_gpures_npt_2.log

echo STMV NPT GPU-resident on 4 GPUs
$NAMD +p29 +pmepes 5 +setcpuaffinity +devices 0,1,2,3 stmv_gpures_npt.namd |& tee out_stmv_gpures_npt_4.log

echo STMV NPT GPU-resident on 8 GPUs
$NAMD +p57 +pmepes 1 +setcpuaffinity +devices 0,1,2,3,4,5,6,7 stmv_gpures_npt.namd |& tee out_stmv_gpures_npt_8.log

