
#ifndef ALIGNEDSTRUCTURE_H
#define ALIGNEDSTRUCTURE_H

#include "alignedSequence.h"
#include "structure.h"
#include "symbolList.h"

#include <stdio.h>

class AlignedStructure : public Structure {

 public:
  AlignedStructure(int l, Alphabet* a, char* n);
  AlignedStructure(int l, Alphabet* a);
  AlignedStructure(Structure* structure, AlignedSequence* alnSeq);
  ~AlignedStructure();

  int addElement(Symbol* symbol, float x, float y, float z);
  int addElement(char c, float x, float y, float z);
  int addElement(Symbol* symbol, Coordinate3D* coord);

  // XXX - REDO ALL ACCESS METHODS IN UNALIGNED VERSIONS;
  //   USE THE DEFAULT PARENT METHODS FOR THE ALIGNED DATA
  int addGap();
  Symbol* getUnalignedSymbol(int i);
  Coordinate3D* getUnalignedCoordinate(int i);
  int getUnalignedLength();
  int alignedToUnalignedIndex(int i);
  int unalignedToAlignedIndex(int i);

 private:
  int* alignedToUnaligned;
  int* unalignedToAligned;
  int  unalignedLength;

};

#endif
