
#ifndef QTOOLS_H
#define QTOOLS_H

#include "structureAlignment.h"

#include <math.h>
#include <stdio.h>
#include <stdlib.h>

class QTools {

 public:
  QTools(StructureAlignment* sa);
  ~QTools();

  int q(int ends);
  int qPerResidue();
  int printQ(FILE* outfile);
  int printMatrix(FILE* outfile, float** mat);
  int printMatrix(FILE* outfile, int** mat);
  int printQPerResidue(FILE* outfile);

 private:
  int getQAln(float** qAln, int** qNorm);   // for q()
  int getQGap(float** qGap, int** qNorm, int ends);   // for q()
  float getQGap(int struct1, int struct2, int** qNorm, int ends);
  int getGapHead(int gapTail, int s1, int s2);
  int getGapTail(int gapHead, int s1, int s2);
  int getBackboneDistances(float* distances, int bb1, int bb2);
  float getBackboneDistance(int structure, int bb1, int bb2);
  //int read();

 private:
  StructureAlignment* alignment;
  float **qScores;      // Q scores between each pair of structures
  float **qPerRes;  // Q per residue scores
  float qPower;         // Empirically derived constant for Q calculation

  //float **qAln;   // Qaln scores between each pair of structures
  //float **qGap;   // Qgap scores betweeh each pair of structures
  //float ***backboneDistances;  // distances between aligned elements
                                 // (typically CA or P atoms)
  

};

#endif
