
#ifndef PDBREADER_H
#define PDBREADER_H

#include "alphabet.h"
#include "coordinate3D.h"
#include "structure.h"
#include "symbol.h"
#include "typeConvert.h"

#include <stdio.h>

class PDBReader {

 public:
  PDBReader(Alphabet* alpha);
  ~PDBReader();

  int setFilename(char* fn);
  int setPath(char* fn);
  Structure* getStructure(int structIndex);
  Structure* getNextStructure();
  //AlignedStructure* getAlignedSequence(int seqIndex);
  //AlignedStructure* getNextAlignedSequence();
  //SequenceAlignment* getSequenceAlignment();
  int getStructureCount();
  int getElementCount();

 private:
  Coordinate3D* readCoordinate3DFromFile(char* str);
  int checkFullName();
  int checkPdbFile(char* file);
  int setNameFromFilename();

 private:
  Alphabet* alphabet;
  char* filename;
  char* path;      // Path to the file
  char* fullName;
  char* structureName;
  //int currentSequence;

};

#endif
