#ifndef MATRIX_H
#define MATRIX_H

//#include <fstream>
//#include <iostream>
#include "alignment.h"

//using namespace std;

class Matrix {
  public:

    int **cell;   // matrix values
    char *label;  // corresponding residues
    int N;        // Matrix dimension(NxN), always square

    int minimumCellValue;
    int getCell(int,int);

    float expectedValue;
    float relativeEntropy;

    void print();
    void printColor(); // color printing. not valid on sgi/sun machines

    void computeFromAlignment(Alignment);
    void computeFromAlignment(Alignment, float);
    void computeFromBlosumFile(char*);

    Matrix();         // uses default 20 amino acids as label
    ~Matrix();
    Matrix(int len);
    Matrix& operator= (const Matrix&);
    const Matrix operator- (const Matrix&);
    const Matrix operator+ (const Matrix&);
    const Matrix operator* (const Matrix&);
    const Matrix operator* (float weight);
    Matrix(const Matrix&);

//  private:

    void computeFrequencies(Alignment, float**, float);
    int residueCharToInt(char residue);

};

#endif
