set infile [open da.dat r]
    
set t {}
set lineCount 0
while {[gets $infile line] >= 0} {
    set lineLength [llength $line]
    if { $lineLength == 0 } {
        error "Incorrectly formatted data file"
    } 
    if { $lineCount == 0 } {
        set nSims [expr ($lineLength-1)/2]
        for { set i 1 } { $i <= $nSims } { incr i } {
            set z($i) {}
            set f($i) {}
        }
        puts "Number of simulations: $nSims"
    }
    
    lappend t [lindex $line 0]

    for { set i 1 } { $i <= $nSims } { incr i } {
        set zInd $i
        set fInd [expr $i+$nSims]
        lappend z($i) [lindex $line $zInd]
        lappend f($i) [lindex $line $fInd]
    }

    incr lineCount
}  

close $infile



