proc enabletrace {} {
    global vmd_frame
    trace variable vmd_frame([molinfo top]) w drawcounter
}

proc disabletrace {} {
    global vmd_frame
    trace vdelete vmd_frame([molinfo top]) w drawcounter
}

set pore_draw_arrows 0

proc enablearrows {} {
    global pore_draw_arrows
    set pore_draw_arrows 1
}

proc disablearrows {} {
    global pore_draw_arrows
    set pore_draw_arrows 0
}

proc vmd_draw_arrow_BASE {mol start end} {
    # an arrow is made of a cylinder and a cone
    set coneEnd [vecadd $end [vecscale 0.25 [vecsub $end $start]]]
    graphics $mol cylinder $start $end radius 1.0
    graphics $mol cone $end $coneEnd radius 1.5
}

proc vmd_draw_arrow {mol start end} {
    set middle [vecadd $start [vecscale 0.8 [vecsub $end $start]]]
    graphics $mol cylinder $start $middle radius 1.0
    graphics $mol cone $middle $end radius 1.5
}

set Rstart     14
set Rrate      0.00001
set Rtarget    4.0
set frameRate  10000
set Center     0.0

set sel [atomselect top "segid ADNA and name P"]
set residList [lsort -integer [$sel get resid] ]
set residStart [lindex $residList 0]
set residEnd   [lindex $residList end]
 
proc drawcounter { name element op } {
    global vmd_frame
    global Rstart
    global Rrate
    global Rtarget
    global frameRate
    global Center
    global pore_draw_arrows
    global residList residStart residEnd
    
    # Calculate the proper radius for this frame
    set R [expr $Rstart - $Rrate*$frameRate*$vmd_frame([molinfo top]) + 1.0]
    if {$R < $Rtarget} { 
	set R $Rtarget
    } 

    # Draw the pore cylinder
    draw delete all
    draw color blue
    #draw material Transparent
    draw material Glass1
    set start_pt [list 0 0 [expr $Center - 30]]
    set stop_pt [list 0 0 [expr $Center + 50]]
    draw cylinder $start_pt $stop_pt radius $R resolution 32
    
    # Draw the DNA as arrows
    if { $pore_draw_arrows } {
	for { set resid  [expr $residStart] } { $resid < $residEnd } { incr resid } {
	    set residONE [expr $resid + 1]
	    set tmpSel1 [atomselect top "resid $resid and name N1 C3' " frame $vmd_frame([molinfo top])]
	    foreach {coordN1 coordC1} [$tmpSel1 get "x y z"] { break }
	    
	    draw color yellow
	    vmd_draw_arrow_BASE top $coordC1 $coordN1
	    set tmpSel2 [atomselect top "(resid $resid and name P) or (resid $residONE and name P)" \
			     frame $vmd_frame([molinfo top])]
	    foreach {coordP1 coordP2} [$tmpSel2 get "x y z"] { break }
	    
	    draw color 14
	    vmd_draw_arrow top $coordP1 $coordP2
	    
	    $tmpSel1 delete
	    $tmpSel2 delete
	}
    }
}

