# Till Rudack, 2015
set input1 cluster_rep_insertion
set input2 4CR2_V 
set sel1 "resid 1 to 137 or resid 158 to 195"
set sel2 "resid 23 to 159 or resid 180 to 217"

set output ${input1}_aligned
mol load pdb  $input1.pdb
mol load pdb  $input2.pdb

# Resid that will be aligned
set sel1 [atomselect 0 "(${sel1}) and backbone"]
set sel2 [atomselect 1 "(${sel2}) and backbone"]
 
set transformation_matrix [measure fit $sel1 $sel2]
puts [$sel1 num]
puts [$sel2 num]

set move_sel1 [atomselect 0 "all"]

$move_sel1 move $transformation_matrix

$move_sel1 writepdb ${output}.pdb 

quit
