#### General config ####
set packagePath "packagepath"
lappend ::auto_path $packagePath
package require RosettaVMD

set vmdexe "vmdexe"
set gnuplotexe "/opt/local/bin/gnuplot"
# Rosetta path
set rosettapath "rosettapath"
set rosettaDBpath "rosettaDBpath"
set platform "linuxgccrelease" ;# or "linuxgccrelease"

#### Custom config ####
set nstruct 100
set bestN 100

# Rosetta Template Path for Rigid Chunk
set tempPath [pwd]/full_length_model
# template directory for alignment in analyze_abinitio
set tempdir [pwd]/full_length_model

set comps [list [list ss 196 284 "A"]];# [list cluster 196 284 "A" 2]]

#start_rosetta_abinitio jobname mol selections anchor fragfiles fragpath nstruct cluster nPerTask testrun
start_rosetta_abinitio rpn11_terminus rpn11_yeast_23-306_complete [list "resid 196 to 284"] 1 [list [list "rpn11_yeast_23-306_frag9" "rpn11_yeast_23-306_frag3"]] [pwd]/input $nstruct 0 0 0
# analyze_abinitio jobname mol bestN nstruct cluster align_template align_rosetta analysis_components
analyze_abinitio rpn11_terminus rpn11_yeast_23-306_complete $bestN $nstruct 0 "resid 100 to 195" "resid 100 to 195" $comps

quit
