### find pdb selection according to density package
### Author: Maximilian Scheurer, April 2016, Mail: mscheurer@ks.uiuc.edu
### requires resmap output!

namespace eval ::DensitySelector {
	set version 0.1
	set description "density selector for pdb+resmap-density"
}
package provide DensitySelector $DensitySelector::version

proc select_by_density {args} \
{
	return [eval ::DensitySelector::select_by_density $args]
}

proc modify_gridpdb {args} \
{
	return [eval ::DensitySelector::modify_gridpdb $args]
}

#MOL: pdb file 
#resmapmap: map with density information generated by resmap (ccp4 format!!!)
#min: minimal resolution value
#max: maximial resolution value
#stepwidth: 
proc ::DensitySelector::select_by_density {MOL resmapmap min max stepwidth} \
{
	set densmol [mol new $MOL.pdb]
	mol addfile $resmapmap.ccp4 molid $densmol

	set binnumber [expr int (double($max - $min)/double($stepwidth) + 1)]
	puts "bins: $binnumber"

	set bins []
	set current $min
	lappend bins $current
	for {set i 1} {$i < $binnumber} {incr i} {
		lappend bins [expr [lindex $bins [expr $i -1]] + $stepwidth]
	}
	puts "bin names: $bins"

	set limits []
	set results []
	set allatoms [atomselect $densmol all]
	for {set i 0} {$i < $binnumber} {incr i} {
		set lower [lindex $bins $i]
		set upper [expr $lower + $stepwidth]
		lappend limits [list $lower $upper]
		set currentsel [atomselect $densmol "interpvol0 >= $lower and interpvol0 < $upper"]
		set indices [$currentsel get index]
		lappend results [list $lower $indices]
		$currentsel set beta $lower
		if {$i == [expr $binnumber -1]} {
			set currentsel [atomselect $densmol "interpvol0 >= $upper"]
			$currentsel set beta $upper
		}
	}
	$allatoms writepdb "$MOL-denssel.pdb"
	puts "bin limits: $limits"
	return $results
	mol delete $densmol
}

proc ::DensitySelector::modify_gridpdb {MOL resmapmap min max stepwidth factor_min factor_max} \
{
	set dfactor [expr $factor_max - $factor_min]
	set stepscaling [expr int (double($max - $min)/double($stepwidth))]
	set factor_step [expr double($dfactor)/double($stepscaling)]

	set results [::DensitySelector::select_by_density $MOL $resmapmap $min $max $stepwidth]
	mol delete all
	set densmol [mol new $MOL.pdb]
	set resultlength [llength $results]
	for {set i 0} {$i < $resultlength} {incr i} {
		set bin [lindex $results $i]
		set binlimit [lindex $bin 0]
		set binindices [lindex $bin 1]
		set currentFactor [expr $factor_max - $i * $factor_step]
		puts "current factor: $currentFactor"
		puts "atoms: [llength $binindices]"
		for {set j 0} {$j < [llength $binindices]} {incr j} {
			set sel [atomselect $densmol "index [lindex $binindices $j]"]
			set beta [$sel get beta]
			set beta_new [expr $beta * $currentFactor]
			$sel set beta $beta_new
			$sel delete
		}

		# foreach idx $binindices {
		# 	set beta [[atomselect $densmol "index $idx"] get beta]
		# 	set beta_new [expr $beta * $currentFactor]
		# 	[atomselect $densmol "index $idx"] set beta $beta_new
		# }
	}
	#make a copy of old gridpdb file!
	exec cp $MOL.pdb $MOL-oldgrid.pdb
	[atomselect $densmol all] writepdb $MOL.pdb
}
