package require psfgen
resetpsf

readpsf solvated.psf
coordpdb solvated.pdb

mol load pdb solvated.pdb psf solvated.psf
set watSel [atomselect top "name W WAF and within 5 of (not name W WAF)"]
set watInd [$watSel get index]

foreach ind $watInd {
    set sel [atomselect top "index $ind"]
    set seg [$sel get segname]
    set res [$sel get resid]
    delatom $seg $res
    # puts "deleting lipid seg $seg resid $res"
    $sel delete
}
  
writepdb solvated2.pdb
writepsf solvated2.psf

exit

