package require cgtools

# load new coarse-grained system
set cgmol [mol new cg-popcpatch.pdb]

####
# make preliminary psf

package require psfgen
resetpsf
topology ../../04-cgc-top-par-files/martini-top/martini-protein.top
topology ../../04-cgc-top-par-files/martini-top/martini-lipids.top

file delete -force -- segments-lipids
file mkdir segments-lipids

set lipidsel [atomselect $cgmol "lipids"]
foreach seg [lsort -unique [$lipidsel get segname]] {
  set sel [atomselect $cgmol "segname $seg"]
  $sel writepdb segments-lipids/segment_$seg.pdb
  $sel delete
}

foreach seg [lsort -unique [$lipidsel get segname]] {
  segment $seg {
    pdb segments-lipids/segment_$seg.pdb
    first none
    last none
  }
  coordpdb segments-lipids/segment_$seg.pdb $seg
}
$lipidsel delete

# initial coarse-grained pdb/psf pair
writepdb cg-popcpatch.pdb
writepsf cg-popcpatch.psf

file delete -force -- segments-lipids

# recentering the patch (for convenience)
mol load pdb cg-popcpatch.pdb
set all [atomselect top all]
$all moveby [vecinvert [measure center $all]]
$all writepdb cg-popcpatch.pdb

exit

