
# set bond strength (trial and error)
set k 10.0

# load system
mol load psf ionized.psf
mol addfile ionized.pdb waitfor all

# open file
set extrabondsfile [open "extrabonds.txt" w+]

# select beads you want to bond
set selA [atomselect top "segname A and resid 34 and name BAS"]
set selB [atomselect top "segname B and resid 34 and name BAS"]
set selC [atomselect top "segname C and resid 34 and name BAS"]
set selD [atomselect top "segname D and resid 34 and name BAS"]
set indexA [$selA get index]
set indexB [$selB get index]
set indexC [$selC get index]
set indexD [$selD get index]
set selAcoords [lindex [$selA get {x y z}] 0]
set selBcoords [lindex [$selB get {x y z}] 0]
set selCcoords [lindex [$selC get {x y z}] 0]
set selDcoords [lindex [$selD get {x y z}] 0]
set distanceAB [veclength [vecsub $selAcoords $selBcoords] ]
set distanceBC [veclength [vecsub $selBcoords $selCcoords] ]
set distanceCD [veclength [vecsub $selCcoords $selDcoords] ]
set distanceDA [veclength [vecsub $selDcoords $selAcoords] ]
# average over the four monomers, get average bond length
set averageDistance [expr ($distanceAB + $distanceBC + $distanceCD + $distanceDA)/4.0 ]
# write out to extraBonds file
puts $extrabondsfile "# resid 34 -> resid 34"
puts $extrabondsfile "bond $indexA $indexB $k $averageDistance"
puts $extrabondsfile "bond $indexB $indexC $k $averageDistance"
puts $extrabondsfile "bond $indexC $indexD $k $averageDistance"
puts $extrabondsfile "bond $indexD $indexA $k $averageDistance"

set selA [atomselect top "segname A and resid 37 and name BAS"]
set selB [atomselect top "segname B and resid 37 and name BAS"]
set selC [atomselect top "segname C and resid 37 and name BAS"]
set selD [atomselect top "segname D and resid 37 and name BAS"]
set indexA [$selA get index]
set indexB [$selB get index]
set indexC [$selC get index]
set indexD [$selD get index]
set selAcoords [lindex [$selA get {x y z}] 0]
set selBcoords [lindex [$selB get {x y z}] 0]
set selCcoords [lindex [$selC get {x y z}] 0]
set selDcoords [lindex [$selD get {x y z}] 0]
set distanceAB [veclength [vecsub $selAcoords $selBcoords] ]
set distanceBC [veclength [vecsub $selBcoords $selCcoords] ]
set distanceCD [veclength [vecsub $selCcoords $selDcoords] ]
set distanceDA [veclength [vecsub $selDcoords $selAcoords] ]
set averageDistance [expr ($distanceAB + $distanceBC + $distanceCD + $distanceDA)/4.0 ]
puts $extrabondsfile "# resid 37 -> resid 37"
puts $extrabondsfile "bond $indexA $indexB $k $averageDistance"
puts $extrabondsfile "bond $indexB $indexC $k $averageDistance"
puts $extrabondsfile "bond $indexC $indexD $k $averageDistance"
puts $extrabondsfile "bond $indexD $indexA $k $averageDistance"

set selA [atomselect top "segname A and resid 27 and name BAS"]
set selB [atomselect top "segname B and resid 27 and name BAS"]
set selC [atomselect top "segname C and resid 27 and name BAS"]
set selD [atomselect top "segname D and resid 27 and name BAS"]
set indexA [$selA get index]
set indexB [$selB get index]
set indexC [$selC get index]
set indexD [$selD get index]
set selAcoords [lindex [$selA get {x y z}] 0]
set selBcoords [lindex [$selB get {x y z}] 0]
set selCcoords [lindex [$selC get {x y z}] 0]
set selDcoords [lindex [$selD get {x y z}] 0]
set distanceAB [veclength [vecsub $selAcoords $selBcoords] ]
set distanceBC [veclength [vecsub $selBcoords $selCcoords] ]
set distanceCD [veclength [vecsub $selCcoords $selDcoords] ]
set distanceDA [veclength [vecsub $selDcoords $selAcoords] ]
set averageDistance [expr ($distanceAB + $distanceBC + $distanceCD + $distanceDA)/4.0 ]
puts $extrabondsfile "# resid 27 -> resid 27"
puts $extrabondsfile "bond $indexA $indexB $k $averageDistance"
puts $extrabondsfile "bond $indexB $indexC $k $averageDistance"
puts $extrabondsfile "bond $indexC $indexD $k $averageDistance"
puts $extrabondsfile "bond $indexD $indexA $k $averageDistance"

set selA [atomselect top "segname A and resid 41 and name BAS"]
set selB [atomselect top "segname B and resid 41 and name BAS"]
set selC [atomselect top "segname C and resid 41 and name BAS"]
set selD [atomselect top "segname D and resid 41 and name BAS"]
set indexA [$selA get index]
set indexB [$selB get index]
set indexC [$selC get index]
set indexD [$selD get index]
set selAcoords [lindex [$selA get {x y z}] 0]
set selBcoords [lindex [$selB get {x y z}] 0]
set selCcoords [lindex [$selC get {x y z}] 0]
set selDcoords [lindex [$selD get {x y z}] 0]
set distanceAB [veclength [vecsub $selAcoords $selBcoords] ]
set distanceBC [veclength [vecsub $selBcoords $selCcoords] ]
set distanceCD [veclength [vecsub $selCcoords $selDcoords] ]
set distanceDA [veclength [vecsub $selDcoords $selAcoords] ]
set averageDistance [expr ($distanceAB + $distanceBC + $distanceCD + $distanceDA)/4.0 ]
puts $extrabondsfile "# resid 41 -> resid 41"
puts $extrabondsfile "bond $indexA $indexB $k $averageDistance"
puts $extrabondsfile "bond $indexB $indexC $k $averageDistance"
puts $extrabondsfile "bond $indexC $indexD $k $averageDistance"
puts $extrabondsfile "bond $indexD $indexA $k $averageDistance"

set selA1 [atomselect top "segname A and resid 30 and name BAS"]
set selB2 [atomselect top "segname B and resid 31 and name BAS"]
set selB1 [atomselect top "segname B and resid 30 and name BAS"]
set selC2 [atomselect top "segname C and resid 31 and name BAS"]
set selC1 [atomselect top "segname C and resid 30 and name BAS"]
set selD2 [atomselect top "segname D and resid 31 and name BAS"]
set selD1 [atomselect top "segname D and resid 30 and name BAS"]
set selA2 [atomselect top "segname A and resid 31 and name BAS"]

set indexA1 [$selA1 get index]
set indexA2 [$selA2 get index]
set indexB1 [$selB1 get index]
set indexB2 [$selB2 get index]
set indexC1 [$selC1 get index]
set indexC2 [$selC2 get index]
set indexD1 [$selD1 get index]
set indexD2 [$selD2 get index]
set selA1coords [lindex [$selA1 get {x y z}] 0]
set selA2coords [lindex [$selA2 get {x y z}] 0]
set selB1coords [lindex [$selB1 get {x y z}] 0]
set selB2coords [lindex [$selB2 get {x y z}] 0]
set selC1coords [lindex [$selC1 get {x y z}] 0]
set selC2coords [lindex [$selC2 get {x y z}] 0]
set selD1coords [lindex [$selD1 get {x y z}] 0]
set selD2coords [lindex [$selD2 get {x y z}] 0]
set distanceAB [veclength [vecsub $selA1coords $selB2coords] ]
set distanceBC [veclength [vecsub $selB1coords $selC2coords] ]
set distanceCD [veclength [vecsub $selC1coords $selD2coords] ]
set distanceDA [veclength [vecsub $selD1coords $selA2coords] ]
set averageDistance [expr ($distanceAB + $distanceBC + $distanceCD + $distanceDA)/4.0 ]
puts $extrabondsfile "# resid 30 -> resid 31"
puts $extrabondsfile "bond $indexA1 $indexB2 $k $averageDistance"
puts $extrabondsfile "bond $indexB1 $indexC2 $k $averageDistance"
puts $extrabondsfile "bond $indexC1 $indexD2 $k $averageDistance"
puts $extrabondsfile "bond $indexD1 $indexA2 $k $averageDistance"

set selA1 [atomselect top "segname A and resid 37 and name BAS"]
set selB2 [atomselect top "segname B and resid 38 and name BAS"]
set selB1 [atomselect top "segname B and resid 37 and name BAS"]
set selC2 [atomselect top "segname C and resid 38 and name BAS"]
set selC1 [atomselect top "segname C and resid 37 and name BAS"]
set selD2 [atomselect top "segname D and resid 38 and name BAS"]
set selD1 [atomselect top "segname D and resid 37 and name BAS"]
set selA2 [atomselect top "segname A and resid 38 and name BAS"]

set indexA1 [$selA1 get index]
set indexA2 [$selA2 get index]
set indexB1 [$selB1 get index]
set indexB2 [$selB2 get index]
set indexC1 [$selC1 get index]
set indexC2 [$selC2 get index]
set indexD1 [$selD1 get index]
set indexD2 [$selD2 get index]
set selA1coords [lindex [$selA1 get {x y z}] 0]
set selA2coords [lindex [$selA2 get {x y z}] 0]
set selB1coords [lindex [$selB1 get {x y z}] 0]
set selB2coords [lindex [$selB2 get {x y z}] 0]
set selC1coords [lindex [$selC1 get {x y z}] 0]
set selC2coords [lindex [$selC2 get {x y z}] 0]
set selD1coords [lindex [$selD1 get {x y z}] 0]
set selD2coords [lindex [$selD2 get {x y z}] 0]
set distanceAB [veclength [vecsub $selA1coords $selB2coords] ]
set distanceBC [veclength [vecsub $selB1coords $selC2coords] ]
set distanceCD [veclength [vecsub $selC1coords $selD2coords] ]
set distanceDA [veclength [vecsub $selD1coords $selA2coords] ]
set averageDistance [expr ($distanceAB + $distanceBC + $distanceCD + $distanceDA)/4.0 ]
puts $extrabondsfile "# resid 37 -> resid 38"
puts $extrabondsfile "bond $indexA1 $indexB2 $k $averageDistance"
puts $extrabondsfile "bond $indexB1 $indexC2 $k $averageDistance"
puts $extrabondsfile "bond $indexC1 $indexD2 $k $averageDistance"
puts $extrabondsfile "bond $indexD1 $indexA2 $k $averageDistance"


set selA1 [atomselect top "segname A and resid 33 and name BAS"]
set selB2 [atomselect top "segname B and resid 34 and name BAS"]
set selB1 [atomselect top "segname B and resid 33 and name BAS"]
set selC2 [atomselect top "segname C and resid 34 and name BAS"]
set selC1 [atomselect top "segname C and resid 33 and name BAS"]
set selD2 [atomselect top "segname D and resid 34 and name BAS"]
set selD1 [atomselect top "segname D and resid 33 and name BAS"]
set selA2 [atomselect top "segname A and resid 34 and name BAS"]

set indexA1 [$selA1 get index]
set indexA2 [$selA2 get index]
set indexB1 [$selB1 get index]
set indexB2 [$selB2 get index]
set indexC1 [$selC1 get index]
set indexC2 [$selC2 get index]
set indexD1 [$selD1 get index]
set indexD2 [$selD2 get index]
set selA1coords [lindex [$selA1 get {x y z}] 0]
set selA2coords [lindex [$selA2 get {x y z}] 0]
set selB1coords [lindex [$selB1 get {x y z}] 0]
set selB2coords [lindex [$selB2 get {x y z}] 0]
set selC1coords [lindex [$selC1 get {x y z}] 0]
set selC2coords [lindex [$selC2 get {x y z}] 0]
set selD1coords [lindex [$selD1 get {x y z}] 0]
set selD2coords [lindex [$selD2 get {x y z}] 0]
set distanceAB [veclength [vecsub $selA1coords $selB2coords] ]
set distanceBC [veclength [vecsub $selB1coords $selC2coords] ]
set distanceCD [veclength [vecsub $selC1coords $selD2coords] ]
set distanceDA [veclength [vecsub $selD1coords $selA2coords] ]
set averageDistance [expr ($distanceAB + $distanceBC + $distanceCD + $distanceDA)/4.0 ]
puts $extrabondsfile "# resid 33 -> resid 34"
puts $extrabondsfile "bond $indexA1 $indexB2 $k $averageDistance"
puts $extrabondsfile "bond $indexB1 $indexC2 $k $averageDistance"
puts $extrabondsfile "bond $indexC1 $indexD2 $k $averageDistance"
puts $extrabondsfile "bond $indexD1 $indexA2 $k $averageDistance"

close $extrabondsfile


exit
