package require psfgen
resetpsf

readpsf solvated.psf
coordpdb solvated.pdb

# select waters that may have ended up in the lipid tail region, and delete them
mol load pdb solvated.pdb psf solvated.psf
set seltext1 "(name W WAF and (z < 16 and z > -16))"
set seltext2 "(name W WAF and within 5 of (not name W WAF))"
set watSel [atomselect top "$seltext1 or $seltext2"]
set watInd [$watSel get index]

foreach ind $watInd {
    set sel [atomselect top "index $ind"]
    set seg [$sel get segname]
    set res [$sel get resid]
    delatom $seg $res
    # puts "deleting lipid seg $seg resid $res"
    $sel delete
}
  
writepdb solvated2.pdb
writepsf solvated2.psf

exit

