
# VMD won't let us redefine "protein"
# and it does not recognize CG residues as being protein residues, even though they have the appropriate resname.
# so we create our own macro to handle it.
atomselect macro cgprotein {resname ALA ARG ASN ASP CYS GLN GLU GLY HSD HSE HSP HIS ILE LEU LYS MET PHE PRO SER THR TRP TYR VAL}

# load the CG pdb into VMD
set cgmol [mol new cg-M2channel-mempatch.pdb]

####
# make preliminary psf

package require psfgen
resetpsf
topology ../../04-cgc-top-par-files/martini-top/martini-protein.top
topology ../../04-cgc-top-par-files/martini-top/martini-lipids.top

file delete -force -- segments-protein
file mkdir segments-protein
file delete -force -- segments-lipids
file mkdir segments-lipids

set protsel [atomselect $cgmol "cgprotein"]
foreach seg [lsort -unique [$protsel get segname]] {
  set sel [atomselect $cgmol "segname $seg"]
  $sel writepdb segments-protein/segment_$seg.pdb
  $sel delete
}

set lipidsel [atomselect $cgmol "resname POPC"]
foreach seg [lsort -unique [$lipidsel get segname]] {
  set sel [atomselect $cgmol "segname $seg"]
  $sel writepdb segments-lipids/segment_$seg.pdb
  $sel delete
}

foreach seg [lsort -unique [$protsel get segname]] {
  segment $seg {
    pdb segments-protein/segment_$seg.pdb
    first none
    last none
    auto none
  }
  coordpdb segments-protein/segment_$seg.pdb $seg
}
$protsel delete

foreach seg [lsort -unique [$lipidsel get segname]] {
  segment $seg {
    pdb segments-lipids/segment_$seg.pdb
    first none
    last none
    auto none
  }
  coordpdb segments-lipids/segment_$seg.pdb $seg
}
$lipidsel delete

writepdb cg-M2channel-mempatch-init.pdb
writepsf cg-M2channel-mempatch-init.psf

# clean up
file delete -force -- segments-protein
file delete -force -- segments-lipids

exit

