
# VMD won't let us redefine "protein"
# and it does not recognize CG residues as being protein residues, even though they have the appropriate resname.
# so we create our own macro to handle it.
atomselect macro cgprotein {resname ALA ARG ASN ASP CYS GLN GLU GLY HSD HSE HSP HIS ILE LEU LYS MET PHE PRO SER THR TRP TYR VAL}

# start cgbuilder
package require cgtools

# load the all-atom files
set aamol [mol new AA-M2channel-mempatch.psf]
mol addfile AA-M2channel-mempatch.pdb waitfor all

# read in the .cgc files
::cgtools::read_db ../../04-cgc-top-par-files/martini-cgc/martini-protein.cgc
::cgtools::read_db ../../04-cgc-top-par-files/martini-cgc/martini-lipids.cgc

# coarse-grain 
::cgtools::apply_database $aamol cg-M2channel-mempatch.pdb cg-M2channel-mempatch.rcg

exit

