package require psfgen
resetpsf

# center the protein on the origin
mol load pdb AA-M2channel.pdb psf AA-M2channel.psf
set protein [atomselect top all]
$protein moveby [vecinvert [measure center $protein]]
$protein writepdb AA-M2channel-centered.pdb

# center the lipid patch on the origin
mol load pdb popcpatch.pdb psf popcpatch.psf
set membrane [atomselect top all]
$membrane moveby [vecinvert [measure center $membrane]]
$membrane writepdb popcpatch-centered.pdb

#combine the protein and lipid files
readpsf popcpatch.psf
coordpdb popcpatch-centered.pdb
readpsf AA-M2channel.psf
coordpdb AA-M2channel-centered.pdb
writepsf AA-M2channel_mempatch_TEMP.psf
writepdb AA-M2channel_mempatch_TEMP.pdb



# Now align the protein with the membrane in the z-direction in VMD.
# In general there is no way to script this.
# See our Membrane Protein tutorial for more information on building and simulating membrane protein systems.

mol delete all

# now remove water and lipids that overlap with the protein

mol load pdb AA-M2channel_mempatch_TEMP.pdb psf AA-M2channel_mempatch_TEMP.psf

# select lipids and water within a certain cutoff from the protein
# there is some trial and error involved in choosing that cutoff
set seltext1 "resname POPC and within 0.6 of protein"
set seltext2 "water and within 1.0 of protein"

set sel1 [atomselect top $seltext1]
set sel2 [atomselect top $seltext2]

set all [atomselect top all]
$all set beta 0
$sel1 set beta 1
$sel2 set beta 1

# get the segnames and resids for the lipids we want to delete
set badlipids [atomselect top "same residue as lipids and beta > 0"]
set seglistlipids [$badlipids get segid]
set reslistlipids [$badlipids get resid]

# get the segname and resid for the waters we want to delete
set badwater [atomselect top "same residue as water and beta > 0"]
set seglistwater [$badwater get segid]
set reslistwater [$badwater get resid]

mol delete all
resetpsf

readpsf AA-M2channel_mempatch_TEMP.psf
coordpdb AA-M2channel_mempatch_TEMP.pdb

# delete the lipids and waters
foreach segid $seglistlipids resid $reslistlipids {delatom $segid $resid}
foreach segid $seglistwater resid $reslistwater {delatom $segid $resid}

# write out our new file
writepsf AA-M2channel-mempatch.psf
writepdb AA-M2channel-mempatch.pdb

# clean up intermediate files
file delete AA-M2channel-centered.pdb
file delete popcpatch-centered.pdb
file delete AA-M2channel_mempatch_TEMP.psf
file delete AA-M2channel_mempatch_TEMP.pdb

exit



